import asyncio
from telegram import Bot
from config import BOT_TOKEN  # ضع توكن البوت هنا في config.py أو مباشرة كسلسلة

# --- ضع هنا معرف المستخدم الذي تريد جلب معلوماته ---
USER_ID = 123456789  # استبدل بالـ Telegram ID الخاص بالمستخدم

async def main():
    bot = Bot(token=BOT_TOKEN)

    try:
        chat = await bot.get_chat(chat_id=USER_ID)
        username = chat.username      # اسم المستخدم @username
        first_name = chat.first_name  # الاسم الأول
        last_name = chat.last_name    # الاسم الأخير
        full_name = f"{first_name} {last_name}" if last_name else first_name

        print("✅ معلومات المستخدم:")
        print(f"• الاسم الكامل: {full_name}")
        print(f"• اسم المستخدم: @{username}" if username else "• اسم المستخدم غير موجود")
    except Exception as e:
        print(f"❌ خطأ عند جلب بيانات المستخدم: {e}")

if __name__ == "__main__":
    asyncio.run(main())
