# main.py

from handlers.admin.users_manage import (
    users_callback_handler, add_balance_handler,
    remove_balance_handler, send_message_handler, cancel_action,
    SELECT_USER, ADD_BALANCE, REMOVE_BALANCE, SEND_MESSAGE,search_user_handler,
    SEARCH_USER
)
from handlers.admin.withdraw_deposit_manage import manage_deposits_menu , toggle_deposit_method_callback
from handlers.admin.deposit_manage import admin_deposits_buttons_handler
from telegram import Update
from handlers.withdraw.chamcash_menu_withdraw import refund_last_withdraw

from handlers.withdraw.chamcash_menu_withdraw import refund_last_withdraw
from handlers.admin.admin_menu import toggle_bot_status ,toggle_syriatel_number_visibility, handle_toggle_syriatel, toggle_deposit_withdraw , manual_referral_distribution , show_earnings_details , confirm_distribute_all , confirm_distribute_ready , distribute_all_earnings , distribute_ready_earnings , manual_referral_distribution
from handlers.deposit.usdt import check_arab_pay_callback
from handlers.admin.cham_cash_withdraw import (
    admin_withdraw_chamcash_start,
    admin_withdraw_chamcash_amount,
    admin_withdraw_chamcash_code,
    ADMIN_WITHDRAW_AMOUNT,
    ADMIN_WITHDRAW_CODE,
    ADMIN_WITHDRAW_CURRENCY,
    admin_withdraw_chamcash_currency
    
)
from config import admin_photo_filter

from handlers.admin.chamcash_withdraw import show_chamcash_balance 

from handlers.admin.referral_manage import (
    AWAITING_REFERRAL_PERCENTAGES,
    start_edit_referral_percentages,
    receive_new_referral_percentages,
    cancel_referral_edit
)
from handlers.admin.admin_states import show_admin_stats , export_weekly_excel

from handlers.admin.hawala_deposit_admin import (
    admin_approve_hawala_deposit,
    admin_reject_hawala_deposit
)
from handlers.admin.manage_rates import (
    manage_rates_menu,
    start_edit_max_withdraw,
    start_edit_min_deposit,
    start_edit_min_withdraw,
    start_edit_bonus_gift,
    start_edit_min_usdt,
    receive_new_value,
    start_edit_withdraw_fee,
    AWAITING_MAX_DIRECT_WITHDRAW,
    AWAITING_MIN_DEPOSIT,
    AWAITING_MIN_WITHDRAW,
    AWAITING_BONUS_GIFT,
    AWAITING_MIN_USDT,
    AWAITING_WITHDRAW_FEE,
    select_method
)


from telegram.ext import (
    ApplicationBuilder,
    CommandHandler,
    ConversationHandler,
    CallbackQueryHandler,
    MessageHandler,
    filters,
)
from handlers.admin.hawala_settings import (
    edit_hawala_info_start,
    receive_hawala_full_name,
    receive_hawala_phone,
    AWAITING_HAWALA_FULL_NAME,
    AWAITING_HAWALA_PHONE
)
from handlers.support.support_settings import (
    set_support_account_start,
    receive_support_username,
    AWAITING_SUPPORT_USERNAME,
    cancel_set_support_account
)
from config import BOT_TOKEN , ADMIN_IDS
from telegram import InlineKeyboardButton, InlineKeyboardMarkup

# ===== استيراد الدوال من المجلدات المنظمة =====

# --- القوائم والواجهة ---
from handlers.menu.main_menu import show_withdraw_history,show_my_transactions ,  show_deposit_history,  show_terms,accept_terms_handler, start, back_to_main_menu ,handle_web_app_data

# --- المصادقة وإنشاء الحساب ---
from handlers.auth.account_creation import (
    my_account_handler,
    receive_username_input,
    receive_password_input,
    AWAITING_USERNAME_INPUT,
    AWAITING_PASSWORD_INPUT,
)
from handlers.deposit.syriatel_dep import deposit_syriatel_start,receive_deposit_syriatel_number ,AWAITING_DEPOSIT_SYRIATEL_NUMBER  ,  cancel_deposit_syriatel , AWAITING_DEPOSIT_SYRIATEL_AMOUNT , receive_deposit_syriatel_amount
# --- الإيداع ---
from handlers.deposit.user_deposit_flow import (
    deposit_start,
    receive_deposit_method,
    receive_deposit_amount,
    receive_deposit_proof,
    cancel_deposit,
    AWAITING_DEPOSIT_METHOD,
    AWAITING_DEPOSIT_AMOUNT,
    AWAITING_DEPOSIT_PROOF,
)

# --- السحب ---
from handlers.withdraw.syriatel_withdraw import (
    withdraw_syriatel_start,
    receive_syriatel_code,
    receive_syriatel_amount,
    cancel_withdraw_client,
    AWAITING_SYRIATEL_CODE,
    AWAITING_SYRIATEL_AMOUNT,
)

from handlers.withdraw.usdt_withdraw import (
    withdraw_usdt_start,
    receive_usdt_amount,
    receive_wallet_address,
    receive_network_type,
    AWAITING_USDT_AMOUNT,
    AWAITING_WALLET_ADDRESS,
    AWAITING_NETWORK_TYPE,
    handle_usdt_withdraw_decision
)

# --- إيشانسي ---
from handlers.ishansy.ishansy_menu import ishansy_menu_handler , confirm_delete_account,cancel_delete_account, delete_my_account_warning
from handlers.ishansy.website_deposit import (
    deposit_start as deposit_website_start,
    receive_deposit_amount as reveive_deposit_website_ammount,
    deposit_bonus_balance,
    AWAITING_WEBSITE_DEPOSIT_AMOUNT,
)
from handlers.ishansy.website_withdraw import (
    withdraw_from_website_start,
    receive_website_withdraw_amount,
    AWAITING_WEBSITE_WITHDRAW_AMOUNT,
    
)

# --- البونصات والهدايا ---
from handlers.gifting.gift_balance import (
    gift_balance_start,
    receive_recipient_id,
    receive_gift_amount,
    cancel_gifting,
    AWAITING_RECIPIENT_ID,
    AWAITING_GIFT_AMOUNT,
)
from handlers.gifting.promo_user import (
    promo_menu_user,
    view_promo_offers,
    activate_promo_code,
    handle_promo_code_input,
    AWAITING_PROMO_CODE_INPUT,
)

# --- الدعم والمحفظة والإحالات ---
from handlers.support.support_handler import support_handler
from handlers.wallet.transaction_history import show_user_transactions, show_all_transactions
from handlers.referral.referral_handler import show_referral_info

# --- لوحة الأدمن ---
from handlers.admin.admin_menu import admin_panel_handler, promo_codes_menu , go_back_to_admin_panel
from handlers.admin.promo_management import (
    start_add_promo_code,
    receive_promo_code_name,
    receive_promo_code_value,
    edit_promo_code,
    receive_promo_code_uses,
    AWAITING_PROMO_CODE_USES,
    select_promo_code_to_edit,
    receive_new_promo_value,
    cancel_promo_operation,
    list_promo_codes,
    confirm_delete_promo_code,
    AWAITING_PROMO_CODE_NAME,
    AWAITING_PROMO_CODE_VALUE,
    AWAITING_NEW_PROMO_VALUE,
    AWAITING_CONFIRM_PUBLISH,
    start_publish_promo_codes, 
    receive_publish_count,
    confirm_publish_promo,
    start_delete_promo_code,
    
)

from handlers.admin.broadcast import (
    start_broadcast_message,
    receive_broadcast_message,
    cancel_broadcast_message,
    AWAITING_BROADCAST_MESSAGE,
)
from handlers.admin.exchange_rate import (
    start_set_rate,
    receive_new_rate,
    AWAITING_EXCHANGE_RATE,
    cancel_and_back_admin
)
from handlers.admin.deposit_approval import approve_deposit, reject_deposit
from handlers.admin.withdraw_approval import handle_withdraw_decision , handle_hawala_withdraw_decision, show_pending_withdrawals, handle_withdraw_decision

# --- اللعبة ---
from handlers.game.game_handler import send_game_button, start_game, choose_box
from constants import (
    AWAITING_START_GAME,
    AWAITING_BOX_CHOICE,
    AWAITING_SHAMCASH_CODE,
    AWAITING_SHAMCASH_AMOUNT,
    AWAITING_SUPPORT_USERNAME,
)



from handlers.withdraw.chamcash_menu_withdraw import (
    withdraw_shamcash_start,
    receive_shamcash_code,
    receive_shamcash_amount,
    cancel_withdraw_shamcash,
    AWAITING_SHAMCASH_CODE,
    AWAITING_SHAMCASH_AMOUNT,
)
from handlers.deposit.usdt import handle_arab_pay_currency
from handlers.admin.admin_callbacks import admin_callback_handler, admin_receive_proof_handler
from constants import AWAITING_HAWALA_PROOF , AWAITING_HAWALA_AMOUNT , AWAITING_HAWALA_NUMBER , AWAITING_HAWALA_NAME
from telegram.ext import MessageHandler, filters
#hawala
from handlers.withdraw.hawala_withdraw import (
    withdraw_hawala_start,
    receive_hawala_amount,
    receive_hawala_number,
    receive_hawala_name,
    admin_approve_hawala,
    admin_reject_hawala,
    receive_hawala_proof,
)

from telegram.ext import ContextTypes
import asyncio
from handlers.referral.referral_scheduler import run_referral_scheduler



# --- دوال مساعدة ---
from handlers.withdraw.cash_syriatel import cash_syriatel_cash_withdraw  # ← مطلوب في syriatel_withdraw.py


from telegram import Bot
bot = Bot(token=BOT_TOKEN)
from handlers.admin.excel import  export_transactions_excel
# --- المحفظة ---
from database import get_user_data
async def handle_withdraw_callback(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    
    data = query.data
    
    if data == "withdraw_choice":
        # استيراد دالة عرض خيارات السحب
        from main import withdraw_choice_handler
        await withdraw_choice_handler(update, context)
        return
async def show_wallet(update, context):
    query = update.callback_query
    await query.answer()
    user_id_str = str(query.from_user.id)

    # جلب بيانات المستخدم من SQLite
    account = get_user_data(user_id_str)
    
    balance = account.get('balance', 0) if account else 0
    bonus = account.get('bonus_balance', 0) if account else 0

    text = (
        f"💼 **محفظتك**:\n\n"
        f"💰 الرصيد القابل للسحب: {int(balance):,} ل.س\n"
        f"🎁 رصيد الهدايا: {int(bonus):,} ل.س"
    )
    
    keyboard = [[InlineKeyboardButton("🔙 العودة", callback_data="back_to_main")]]
    await query.edit_message_text(
        text,
        reply_markup=InlineKeyboardMarkup(keyboard),
        parse_mode='Markdown'
    )
def is_deposit_withdraw_enabled():
    from database import _get_setting
    """التحقق مما إذا كانت عمليات الإيداع والسحب مفعلة من قاعدة البيانات."""
    return _get_setting("deposit_withdraw_enabled", True)

async def withdraw_choice_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    if not is_deposit_withdraw_enabled():
        await query.edit_message_text("⛔ عمليات السحب حالياً متوقفة من قبل الأدمن.")
        return ConversationHandler.END

    # إلغاء العملية السابقة إذا كانت نشطة
    if context.user_data.get("is_withdrawing"):
        context.user_data.clear()
        await query.edit_message_text("❌ تم إلغاء العملية السابقة تلقائيًا بسبب الضغط على زر جديد.")
        # لا نعود END هنا لأننا سنبدأ عملية جديدة

    # إذا ضغط على "شام كاش"
    if query.data == "withdraw_shamcash":
        keyboard = [
            [InlineKeyboardButton("💵 سحب بالدولار", callback_data="withdraw_sham_usd")],
            [InlineKeyboardButton("💴 سحب بالليرة السورية", callback_data="withdraw_sham_syr")],
            [InlineKeyboardButton("❌ إلغاء العملية", callback_data="cancel_withdraw")]
        ]
        await query.edit_message_text(
            "💰 اختر نوع العملة لسحب شام كاش:",
            reply_markup=InlineKeyboardMarkup(keyboard),
            parse_mode='HTML'
        )
        return "AWAITING_WITHDRAW_CURRENCY"

    # القائمة الرئيسية للسحب
    keyboard = [
        [InlineKeyboardButton("💳 Sham Cash (USD , SYP)", callback_data="withdraw_shamcash")],
        [InlineKeyboardButton("💵 Syriatel Cash", callback_data="withdraw_syriatel"),
         InlineKeyboardButton("🪙 USDT", callback_data="withdraw_usdt")],
        [InlineKeyboardButton("🏦 سحب عن طريق حوالة", callback_data="withdraw_hawalaa")],
        [InlineKeyboardButton("🔙 العودة للقائمة الرئيسية", callback_data="back_to_main")]
    ]
    if query.data == "withdraw_hawalaa":
        await withdraw_hawala_handler(update, context)
        return ConversationHandler.END

    await query.edit_message_text(
        "💰 <b>اختر طريقة السحب:</b>",
        reply_markup=InlineKeyboardMarkup(keyboard),
        parse_mode="HTML"
    )
   
    return  # ← هذه السطر غير مكتمل! ما هو الـ state الذي يجب إرجاعه؟

# ===== استيراد قاعدة البيانات =====
async def withdraw_hawala_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    # جلب الحد الأدنى للسحب من config
    from config import get_config
    config = get_config()
    min_hawala = config.get("MINIMUM_WITHDRAWAL", {}).get("HAWALA", 1500000)
    
    # رسالة الحوالة البسيطة فقط
    hawala_message = (
        f"🏦 <b>سحب عن طريق حوالة مصرفية</b>\n\n"
        f"📊 <b>الحد الأدنى للسحب:</b> <code>{min_hawala:,}</code> ل.س\n\n"
        f"📍 <b>لإكمال العملية يرجى التواصل مع الدعم عبر زر 'مراسلة الدعم' في القائمة الرئيسية.</b>\n\n"
        f"📞 <b>للتواصل مع الدعم:</b>\n"
        f"1. اضغط على زر 'مراسلة الدعم' في القائمة الرئيسية\n"
        f"2. اشرح أنك تريد سحب مبلغ بالحوالة\n"
        f"3. حدد المبلغ الذي تريد سحبه\n"
        f"4. انتظر تعليمات الدعم لاستكمال العملية"
    )
    
    # زر العودة فقط بدون زر الدعم
    keyboard = [
        [InlineKeyboardButton("🔙 العودة لقائمة السحب", callback_data="withdraw_choice")]
    ]
    
    await query.edit_message_text(
        hawala_message,
        reply_markup=InlineKeyboardMarkup(keyboard),
        parse_mode="HTML"
    )
    
    return ConversationHandler.END

def main():
    
    application = ApplicationBuilder().token(BOT_TOKEN).build()
    from handlers.withdraw.cash_syriatel import set_bot
    set_bot(application.bot)
    from handlers.withdraw.cash_syriatel import set_bot_and_job_queue
    set_bot_and_job_queue(application.bot, application.job_queue)
    
    # ===== ConversationHandlers =====
    conv_handlers = [
        # ✅ إنشاء حساب
        ConversationHandler(
            entry_points=[
                CommandHandler("start", start),
                CallbackQueryHandler(my_account_handler, pattern="^my_account$")
            ],
            states={
                AWAITING_USERNAME_INPUT: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_username_input)],
                AWAITING_PASSWORD_INPUT: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_password_input)],
            },
            fallbacks=[
                CommandHandler("start", start), # ⬅️ لإلغاء المحادثة والبدء من جديد
                CommandHandler("cancel", cancel_withdraw_client),
                CallbackQueryHandler(start, pattern="^.*$"), # ⬅️ لإلغاء المحادثة عند ضغط أي زر
            ],
            allow_reentry=True # ⬅️ للسماح بـ /start بإنهاء المحادثة ثم البدء من جديد
        ),
        # سحب من الموقع
        # سحب من الموقع (معدّل)
        ConversationHandler(
            entry_points=[CallbackQueryHandler(withdraw_from_website_start, pattern="^withdraw_from_website$")],
            states={AWAITING_WEBSITE_WITHDRAW_AMOUNT: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_website_withdraw_amount)]},
            fallbacks=[
                CommandHandler("start", start), # ⬅️ موجود مسبقاً
                CallbackQueryHandler(start, pattern="^.*$"), # ⬅️ لمعالجة الأزرار
            ],
            allow_reentry=True # ⬅️ إضافة هذا السطر
        ),
        # إيداع إلى الموقع
        # إيداع إلى الموقع (معدّل)
        ConversationHandler(
            entry_points=[CallbackQueryHandler(deposit_website_start, pattern="^deposit_on_website$")],
            states={AWAITING_WEBSITE_DEPOSIT_AMOUNT: [MessageHandler(filters.TEXT & ~filters.COMMAND, reveive_deposit_website_ammount)]},
            fallbacks=[
                CommandHandler("start", start), # ⬅️ موجود مسبقاً
                CallbackQueryHandler(start, pattern="^.*$"), # ⬅️ لمعالجة الأزرار
            ],
            allow_reentry=True # ⬅️ إضافة هذا السطر
        ),        # إيداع للبوت
           # main.py

# ... (قبل السطر: إيداع للبوت)

# إيداع للبوت
        ConversationHandler(
            entry_points=[CallbackQueryHandler(deposit_start, pattern="^deposit$")],
            states={
                AWAITING_DEPOSIT_METHOD: [
                    CallbackQueryHandler(receive_deposit_method, pattern="^dep_method_"),
                    CallbackQueryHandler(receive_deposit_method, pattern="^cham_cash_(usd|syr)$"),
                    CallbackQueryHandler(cancel_deposit, pattern="^cancel_deposit$"),
                ],
                AWAITING_DEPOSIT_AMOUNT: [
                    MessageHandler(filters.TEXT & ~filters.COMMAND, receive_deposit_amount),
                    CallbackQueryHandler(cancel_deposit, pattern="^cancel_deposit$"),
                ],
                AWAITING_DEPOSIT_PROOF: [
                    MessageHandler(filters.TEXT | filters.PHOTO, receive_deposit_proof),
                    CallbackQueryHandler(cancel_deposit, pattern="^cancel_deposit$"),
                ],
            },
            fallbacks=[
                # ⬅️ التعديل رقم 1: إضافة CommandHandler("start", start) هنا
                CommandHandler("start", start),
                CommandHandler("cancel", cancel_deposit),
                CallbackQueryHandler(cancel_deposit, pattern="^cancel_deposit$"),
            ],
            # ⬅️ التعديل رقم 2: إضافة allow_reentry=True 
            # هذا يسمح للبوت بإنهاء المحادثة ثم الدخول إليها مرة أخرى عبر /start أو زر القائمة.
            allow_reentry=True 
        ),
        # سحب سيرياتيل
        # سحب سيرياتيل (مُعدّل)
        ConversationHandler(
            entry_points=[CallbackQueryHandler(withdraw_syriatel_start, pattern="^withdraw_syriatel$")],
            states={
                AWAITING_SYRIATEL_CODE: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_syriatel_code)],
                AWAITING_SYRIATEL_AMOUNT: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_syriatel_amount)],
            },
            fallbacks=[
                # ⬅️ إضافة /start كـ fallback
                CommandHandler("start", start),
                CallbackQueryHandler(cancel_withdraw_client, pattern="^cancel_withdraw_client$")
            ],
            # ⬅️ إضافة allow_reentry
            allow_reentry=True 
        ),

        # لعبة الصناديق
        ConversationHandler(
            entry_points=[CallbackQueryHandler(send_game_button, pattern="^game$")],
            states={
                AWAITING_START_GAME: [CallbackQueryHandler(start_game, pattern="^start_game$")],
                AWAITING_BOX_CHOICE: [CallbackQueryHandler(choose_box, pattern="^choose_box:")],
            },
            fallbacks=[CommandHandler("cancel", lambda u, c: u.callback_query.answer("❌ تم إلغاء اللعبة"))],
        ),
        # سحب شام كاش
        # سحب شام كاش
        # سحب شام كاش
        # سحب شام كاش (مُعدّل)
        # ===== ConversationHandler لسحب شام كاش مع اختيار العملة =====
        ConversationHandler(
            entry_points=[CallbackQueryHandler(withdraw_choice_handler, pattern="^withdraw_shamcash$")], # تبدأ عند الضغط على زر "شام كاش"
            states={
                # ← المرحلة الأولى: اختيار العملة USD أو SYP
                "AWAITING_WITHDRAW_CURRENCY": [CallbackQueryHandler(cancel_withdraw_shamcash, pattern="^cancel_withdraw$"),
                    CallbackQueryHandler(
                        withdraw_shamcash_start, # ← هذه الدالة تبدأ بعد اختيار العملة
                        pattern="^withdraw_sham_(usd|syr)$"
                    ),
                ],
                # ← المرحلة الثانية: استلام رمز العميل
                AWAITING_SHAMCASH_CODE: [
                    MessageHandler(filters.TEXT & ~filters.COMMAND, receive_shamcash_code),
                    CallbackQueryHandler(cancel_withdraw_shamcash, pattern="^cancel_withdraw_shamcash$")
                ],
                # ← المرحلة الثالثة: استلام المبلغ وإرسال الطلب
                AWAITING_SHAMCASH_AMOUNT: [
                    MessageHandler(filters.TEXT & ~filters.COMMAND, receive_shamcash_amount),
                    CallbackQueryHandler(cancel_withdraw_shamcash, pattern="^cancel_withdraw_shamcash$")
                ],
            },
            fallbacks=[
                CommandHandler("start", start),
                CommandHandler("cancel", cancel_withdraw_shamcash),
                CallbackQueryHandler(cancel_withdraw_shamcash, pattern="^cancel_withdraw_shamcash$"),
                # fallback إضافي لإلغاء العملية عند الضغط على زر العودة للقائمة من مرحلة اختيار العملة
                CallbackQueryHandler(start, pattern="^back_to_main$") 
            ],
            allow_reentry=True,
            # تحديد اسم مميز للمحادثة (اختياري لكن مفيد)
            name="shamcash_withdraw_conversation", 
            # تحديد ما إذا كانت المحادثة لكل مستخدم أم لكل محادثة (مستخدم واحد عادةً)
            per_user=True 
        ),

        # سحب USDT
        # سحب USDT (مُعدّل)
        ConversationHandler(
            entry_points=[CallbackQueryHandler(withdraw_usdt_start, pattern="^withdraw_usdt$")],
            states={
                AWAITING_USDT_AMOUNT: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_usdt_amount)],
                AWAITING_WALLET_ADDRESS: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_wallet_address)],
                AWAITING_NETWORK_TYPE: [CallbackQueryHandler(receive_network_type, pattern="^network_")],
            },
            fallbacks=[
                # ⬅️ إضافة /start كـ fallback
                CommandHandler("start", start),
                CommandHandler("cancel", cancel_withdraw_client)
            ],
            # ⬅️ إضافة allow_reentry
            allow_reentry=True 
        ),
        # إهداء الرصيد
        ConversationHandler(
            entry_points=[CallbackQueryHandler(gift_balance_start, pattern="^gift_balance$")],
            states={
                AWAITING_RECIPIENT_ID: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_recipient_id)],
                AWAITING_GIFT_AMOUNT: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_gift_amount)],
            },
            fallbacks=[CommandHandler("cancel", cancel_gifting)],
            allow_reentry=True,
        ),
        # 🏦 سحب حوالة (هرم / فؤاد)
        # 🏦 سحب حوالة (هرم / فؤاد) (مُعدّل)
        ConversationHandler(
            entry_points=[CallbackQueryHandler(withdraw_hawala_start, pattern="^withdraw_hawala$")],
            states={
                
                AWAITING_HAWALA_AMOUNT: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_hawala_amount)],
                AWAITING_HAWALA_NUMBER: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_hawala_number)],
                AWAITING_HAWALA_NAME: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_hawala_name)],
                AWAITING_HAWALA_PROOF: [MessageHandler(admin_photo_filter, receive_hawala_proof)],
            },
            fallbacks=[
                # ⬅️ إضافة /start كـ fallback
                CommandHandler("start", start),
                CommandHandler("cancel", cancel_withdraw_client)
            ],
            # ⬅️ إضافة allow_reentry
            allow_reentry=True 
        ),

        # لوحة الأدمن
        ConversationHandler(
            entry_points=[CallbackQueryHandler(admin_panel_handler, pattern="^admin_panel$")],
            states={},
            fallbacks=[],
            allow_reentry=True,
        ),
        # تعيين حساب الدعم
        ConversationHandler(
            entry_points=[CallbackQueryHandler(set_support_account_start, pattern="^set_support_account$")],
            states={AWAITING_SUPPORT_USERNAME: [CallbackQueryHandler(cancel_set_support_account, pattern="^cancel_support$"),CallbackQueryHandler(go_back_to_admin_panel, pattern="^admin_panel$"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_support_username)]},
            fallbacks=[ CallbackQueryHandler(admin_panel_handler, pattern="^admin_panel$"),CommandHandler("cancel", cancel_withdraw_client)],
            name="support_setup_conversation",
            persistent=False,
            allow_reentry=True,
        ),
        # بث جماعي
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_broadcast_message, pattern="^broadcast_message$")],
            states={AWAITING_BROADCAST_MESSAGE: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_broadcast_message)]},
            fallbacks=[CallbackQueryHandler(go_back_to_admin_panel, pattern="^admin_panel$"),CommandHandler("cancel", cancel_broadcast_message)],
            allow_reentry=True,
        ),
        # سعر الصرف
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_set_rate, pattern="^set_exchange_rate$")],
            states={AWAITING_EXCHANGE_RATE: [CallbackQueryHandler(cancel_and_back_admin, pattern="^cancel_and_back_admin$"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_rate)]},
            fallbacks=[],
            allow_reentry=True,
        ),
        ConversationHandler(
            entry_points=[CallbackQueryHandler(handle_arab_pay_currency, pattern=r"^usdt_arab_pay_id_")],
            states={
                AWAITING_DEPOSIT_AMOUNT: [
                    MessageHandler(filters.TEXT & ~filters.COMMAND, receive_deposit_amount)
                ],
                AWAITING_DEPOSIT_PROOF: [
                    CallbackQueryHandler(check_arab_pay_callback, pattern=r"^check_arab_pay:")
                ],
            },
            fallbacks=[CommandHandler("cancel", lambda u,c: u.message.reply_text("❌ تم الإلغاء"))],
            allow_reentry=True,
        ),
        #بيانات الحوالة
        ConversationHandler(
            entry_points=[CallbackQueryHandler(edit_hawala_info_start, pattern="^edit_hawala_info$")],
            states={
                AWAITING_HAWALA_FULL_NAME: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_hawala_full_name)],
                AWAITING_HAWALA_PHONE: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_hawala_phone)],
            },
            fallbacks=[CommandHandler("cancel", cancel_broadcast_message)],  # أو أي دالة إلغاء
            allow_reentry=True,
        ),
        
        ConversationHandler(
            entry_points=[CallbackQueryHandler(deposit_syriatel_start, pattern="^manual_deposit$")],
            states={
                AWAITING_DEPOSIT_SYRIATEL_NUMBER: [
                    MessageHandler(filters.TEXT & ~filters.COMMAND, receive_deposit_syriatel_number),
                    CallbackQueryHandler(cancel_deposit_syriatel, pattern="^cancel_deposit_syriatel$")
                ],
                AWAITING_DEPOSIT_SYRIATEL_AMOUNT: [
                    MessageHandler(filters.TEXT & ~filters.COMMAND, receive_deposit_syriatel_amount),
                    CallbackQueryHandler(cancel_deposit_syriatel, pattern="^cancel_deposit_syriatel$")
                ]
            },
            fallbacks=[
                CommandHandler("cancel", lambda update, context: (
                    context.user_data.clear(),
                    update.message.reply_text("❌ تم إلغاء العملية.")
                ))
            ],
            allow_reentry=True
        ),

        # إضافة كود هدية
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_add_promo_code, pattern="^add_promo_code$")],
            states={
                AWAITING_PROMO_CODE_NAME: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_promo_code_name)],
                AWAITING_PROMO_CODE_VALUE: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_promo_code_value)],
                AWAITING_PROMO_CODE_USES: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_promo_code_uses)],
            },
            fallbacks=[CommandHandler("cancel", cancel_promo_operation)],
            allow_reentry=True,
        ),
        # تعديل كود هدية
        ConversationHandler(
            entry_points=[CallbackQueryHandler(edit_promo_code, pattern="^edit_promo_code$")],
            states={AWAITING_NEW_PROMO_VALUE: [MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_promo_value)]},
            fallbacks=[CommandHandler("cancel", cancel_promo_operation)],
            allow_reentry=True,
        ),
        # تفعيل كود هدية
        ConversationHandler(
            entry_points=[CallbackQueryHandler(activate_promo_code, pattern="^activate_promo_code$")],
            states={AWAITING_PROMO_CODE_INPUT: [MessageHandler(filters.TEXT & ~filters.COMMAND, handle_promo_code_input)]},
            fallbacks=[CommandHandler("cancel", lambda u, c: u.message.reply_text("❌ تم إلغاء التفعيل."))],
            allow_reentry=True,
        ),
        #users
        # إدارة المستخدمين
        # إدارة المستخدمين
        
        # إدارة نسب السحب والبونص والإعدادات
        # إدارة نسب السحب والبونص والإعدادات
        
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_edit_max_withdraw, pattern="^edit_max_withdraw$")],
            states={AWAITING_MAX_DIRECT_WITHDRAW: [CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_value)]},
            fallbacks=[CommandHandler("cancel", lambda u, c: u.callback_query.answer("تم الإلغاء"))],
            allow_reentry=True,
        ),
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_edit_min_deposit, pattern="^edit_min_deposit$")],
            states={AWAITING_MIN_DEPOSIT: [CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_value)]},
            fallbacks=[CommandHandler("cancel", lambda u, c: u.callback_query.answer("تم الإلغاء"))],
            allow_reentry=True,
        ),
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_edit_min_withdraw, pattern="^edit_min_withdraw$")],
            states={AWAITING_MIN_WITHDRAW: [CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_value)]},
            fallbacks=[CommandHandler("cancel", lambda u, c: u.callback_query.answer("تم الإلغاء"))],
            allow_reentry=True,
        ),
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_edit_bonus_gift, pattern="^edit_bonus_gift$")],
            states={AWAITING_BONUS_GIFT: [CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_value)]},
            fallbacks=[CommandHandler("cancel", lambda u, c: u.callback_query.answer("تم الإلغاء"))],
            allow_reentry=True,
        ),
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_edit_min_usdt, pattern="^edit_min_usdt$")],
            states={
                AWAITING_MIN_USDT: [CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_value)],
                AWAITING_MAX_DIRECT_WITHDRAW: [CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_value)],
            },
            fallbacks=[CommandHandler("cancel", lambda u, c: u.callback_query.answer("تم الإلغاء"))],
            allow_reentry=True,
        ),
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_edit_withdraw_fee, pattern="^edit_withdraw_fee$")],
            states={AWAITING_WITHDRAW_FEE: [CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_value)]},
            fallbacks=[CommandHandler("cancel", lambda u, c: u.callback_query.answer("تم الإلغاء"))],
            allow_reentry=True,
        ),
        ConversationHandler(
            entry_points=[CallbackQueryHandler(start_publish_promo_codes, pattern="^publish_promo_codes$")],
            states={
                "AWAITING_PUBLISH_COUNT": [
                    CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),
                    MessageHandler(filters.TEXT & ~filters.COMMAND, receive_publish_count),
                ],
                AWAITING_CONFIRM_PUBLISH: [
                    CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates_menu$"),
                    CallbackQueryHandler(confirm_publish_promo, pattern="^confirm_publish_promo$"),
                ],
            },
            fallbacks=[CommandHandler("cancel", lambda u,c: u.message.reply_text("❌ تم الإلغاء"))],
            allow_reentry=True,
        ),
        

        ConversationHandler(
            entry_points=[CallbackQueryHandler(admin_withdraw_chamcash_start, pattern="^admin_withdraw_chamcash$")],
            states={
                # المرحلة 1: اختيار العملة
                ADMIN_WITHDRAW_CURRENCY: [
                    CallbackQueryHandler(admin_withdraw_chamcash_currency, pattern="^(admin_usd|admin_syr|cancel_withdraw)$")
                ],

                # المرحلة 2: إدخال المبلغ
                ADMIN_WITHDRAW_AMOUNT: [
                    MessageHandler(filters.TEXT & ~filters.COMMAND, admin_withdraw_chamcash_amount)
                ],

                # المرحلة 3: إدخال كود العميل
                ADMIN_WITHDRAW_CODE: [
                    MessageHandler(filters.TEXT & ~filters.COMMAND, admin_withdraw_chamcash_code)
                ],
            },
            fallbacks=[
                # الفال باك من زر الإلغاء أو أوامر /start و /cancel
                CallbackQueryHandler(lambda u, c: ConversationHandler.END, pattern="^cancel_withdraw$"),
                CommandHandler("start", lambda update, context: (
                    context.user_data.clear(),
                    update.message.reply_text("✅ تم إلغاء عملية سحب شام كاش.")
                )),
                CommandHandler("cancel", lambda update, context: (
                    context.user_data.clear(),
                    update.message.reply_text("❌ تم إلغاء العملية.")
                ))
            ],
            allow_reentry=True
        )



    ]

    for handler in conv_handlers:
        application.add_handler(handler)

    # ===== معالجات بسيطة =====
    
    application.add_handler(CallbackQueryHandler(admin_panel_handler, pattern="^admin_panel$"))
    application.add_handler(CallbackQueryHandler(ishansy_menu_handler, pattern="^ishansy_menu$"))
    application.add_handler(CallbackQueryHandler(withdraw_choice_handler, pattern="^withdraw$"))
    application.add_handler(CallbackQueryHandler(show_wallet, pattern="^wallet$"))
    application.add_handler(CallbackQueryHandler(show_referral_info, pattern=r'^referrals(_page_\d+)?$'))
    application.add_handler(CallbackQueryHandler(support_handler, pattern="^support$"))
    application.add_handler(CallbackQueryHandler(back_to_main_menu, pattern="^back_to_main$"))
    application.add_handler(
    CallbackQueryHandler(
        callback=show_terms,
        pattern="^terms_conditions$"
    )

)
    application.add_handler(CallbackQueryHandler(cancel_broadcast_message, pattern=r'^cancel_broadcast$'))

    # ===== حذف الحساب في قائمة إيشانسي =====
    application.add_handler(CallbackQueryHandler(delete_my_account_warning, pattern="^delete_my_account_warning$"))
    application.add_handler(CallbackQueryHandler(confirm_delete_account, pattern="^confirm_delete_account$"))
    application.add_handler(CallbackQueryHandler(cancel_delete_account, pattern="^cancel_delete_account$"))

    application.add_handler(
    CallbackQueryHandler(accept_terms_handler, pattern="^accept_terms$")
)
    application.add_handler(CallbackQueryHandler(show_my_transactions, pattern="^show_my_transactions$"))
    application.add_handler(CallbackQueryHandler(show_withdraw_history, pattern="^withdraw_history$"))
    application.add_handler(CallbackQueryHandler(show_deposit_history, pattern="^deposit_history$"))

    # 1. معالج للتنقل في القوائم (لا يحتاج محادثة)
    
    # 2. معالج للإجراءات التي تبدأ محادثة (مثل البحث أو إدخال مبلغ)
    

    # 3. سجّل الـ ConversationHandlers لكل حالة إدخال على حدة

    # البحث عن مستخدم
    search_conv = ConversationHandler(
        entry_points=[CallbackQueryHandler(users_callback_handler, pattern="^search_user_prompt$")],
        states={SEARCH_USER: [MessageHandler(filters.TEXT & ~filters.COMMAND, search_user_handler)]},
        fallbacks=[CommandHandler("cancel", cancel_action)],
        allow_reentry=True
    )

    # إضافة/سحب رصيد
    balance_conv = ConversationHandler(
        entry_points=[
            CallbackQueryHandler(users_callback_handler, pattern="^add_balance$"),
            CallbackQueryHandler(users_callback_handler, pattern="^remove_balance$")
        ],
        states={
            ADD_BALANCE: [MessageHandler(filters.TEXT & ~filters.COMMAND, add_balance_handler)],
            REMOVE_BALANCE: [MessageHandler(filters.TEXT & ~filters.COMMAND, remove_balance_handler)]
        },
        fallbacks=[CommandHandler("cancel", cancel_action)],
        allow_reentry=True
    )

    # إرسال رسالة
    message_conv = ConversationHandler(
        entry_points=[CallbackQueryHandler(users_callback_handler, pattern="^message_user$")],
        states={SEND_MESSAGE: [MessageHandler(filters.TEXT & ~filters.COMMAND, send_message_handler)]},
        fallbacks=[CommandHandler("cancel", cancel_action)],
        allow_reentry=True
    )

    # 4. أضف الـ Conversations
    application.add_handler(search_conv)
    application.add_handler(balance_conv)
    application.add_handler(message_conv)
    # ===== قرارات الأدمن =====
    # ===== قرارات الأدمن =====
    application.add_handler(
        CallbackQueryHandler(
            admin_deposits_buttons_handler,
            pattern="^(pending_deposits|approve_deposit:.*|reject_deposit:.*)$"
        )
    )


    application.add_handler(CallbackQueryHandler(toggle_bot_status, pattern="^toggle_bot_status$"))
    application.add_handler(CallbackQueryHandler(
        users_callback_handler,
        pattern=r"^(users_page:\d+|user_info:\d+|user_history|ban_user|unban_user|back_to_admin|search_user_prompt|add_balance|remove_balance|message_user)$"
    ))
    application.add_handler(
    CallbackQueryHandler(handle_withdraw_decision, pattern=r"^(approve_withdraw|reject_withdraw):.+$")
)

    application.add_handler(CallbackQueryHandler(go_back_to_admin_panel, pattern="^admin_panel$"))
    application.add_handler(CallbackQueryHandler(cancel_set_support_account, pattern=r'^cancel_support$'))
    # زر تشغيل/إيقاف الشحن والسحب
    application.add_handler(CallbackQueryHandler(toggle_deposit_withdraw, pattern="^toggle_deposit_withdraw$"))
    application.add_handler(CallbackQueryHandler(
        withdraw_hawala_handler,
        pattern="^withdraw_hawalaa$"  # ✅ نفس النمط المستخدم في الكود
    ))


    application.add_handler(
    CallbackQueryHandler(
        handle_hawala_withdraw_decision,
        pattern=r"^(hawala_approve|hawala_reject):"  # تطابق أزرار الحوالة
    )
    )
    application.add_handler(ConversationHandler(
    entry_points=[CallbackQueryHandler(start_edit_referral_percentages, pattern="^edit_referral_percentages$")],
    states={AWAITING_REFERRAL_PERCENTAGES: [CallbackQueryHandler(cancel_referral_edit, pattern="cancel_referral_edit"),MessageHandler(filters.TEXT & ~filters.COMMAND, receive_new_referral_percentages)]},
    fallbacks=[],
    allow_reentry=True
    ))
    application.add_handler(
    CallbackQueryHandler(show_admin_stats, pattern="^admin_stats$")
)

    application.add_handler(CallbackQueryHandler(export_transactions_excel, pattern="^export_transactions_excel$"))
    # قرارات الأدمن الخاصة بسحب USDT
    application.add_handler(CallbackQueryHandler(show_pending_withdrawals, pattern="^pending_withdrawals$"))
    application.add_handler(CallbackQueryHandler(handle_withdraw_decision, pattern="^(approve_withdraw|reject_withdraw):"))
    application.add_handler(MessageHandler(filters.StatusUpdate.WEB_APP_DATA, handle_web_app_data))
    application.add_handler(
        CallbackQueryHandler(admin_approve_hawala_deposit, pattern=r"^admin_deposit_hawala_approve:")
    )
    application.add_handler(
        CallbackQueryHandler(admin_reject_hawala_deposit, pattern=r"^admin_deposit_hawala_reject:")
    )
    application.add_handler(CallbackQueryHandler(admin_callback_handler, pattern=r"^(hawala_approve|hawala_reject):"))
    application.add_handler(MessageHandler(admin_photo_filter, admin_receive_proof_handler))
    application.add_handler(CallbackQueryHandler(select_method, pattern=r"^edit_method:"))
    application.add_handler(
        CallbackQueryHandler(admin_panel_handler, pattern="^back_to_admin_panel$")
    )
    application.add_handler(CallbackQueryHandler(show_chamcash_balance, pattern="^show_chamcash_balance$"))


    # ===== سجلات العمليات =====
    application.add_handler(CallbackQueryHandler(show_user_transactions, pattern="^show_my_transactions$"))
    application.add_handler(CallbackQueryHandler(show_all_transactions, pattern="^show_all_transactions$"))

    # ===== البونصات =====
    application.add_handler(CallbackQueryHandler(promo_codes_menu, pattern="^promo_codes_menu$"))
    application.add_handler(CallbackQueryHandler(list_promo_codes, pattern="^list_promo_codes$"))
    application.add_handler(CallbackQueryHandler(start_delete_promo_code, pattern="^delete_promo_code$"))
    application.add_handler(CallbackQueryHandler(start_delete_promo_code, pattern="^delete_admin_promo_code$"))
    application.add_handler(CallbackQueryHandler(confirm_delete_promo_code, pattern="^delete_code:"))
    application.add_handler(CallbackQueryHandler(handle_withdraw_callback, pattern="^withdraw_choice$"))
    application.add_handler(CallbackQueryHandler(confirm_delete_promo_code, pattern="^delete_code:"))
    application.add_handler(CallbackQueryHandler(select_promo_code_to_edit, pattern="^select_edit_code:"))
    application.add_handler(CallbackQueryHandler(promo_menu_user, pattern="^promo_menu_user$"))
    application.add_handler(CallbackQueryHandler(view_promo_offers, pattern="^view_promo_offers$"))
    application.add_handler(CallbackQueryHandler(deposit_bonus_balance, pattern="^transfer_bonus_to_ishansi$"))
    application.add_handler(CallbackQueryHandler(manage_rates_menu, pattern="^manage_rates$"))
    application.add_handler(CallbackQueryHandler(start_publish_promo_codes, pattern="^publish_promo_codes$"))
    application.add_handler(
    CallbackQueryHandler(export_weekly_excel, pattern="^export_weekly_excel$")
    )
    application.add_handler(
        CallbackQueryHandler(check_arab_pay_callback, pattern=r"^check_arab_pay:")
    )
    application.add_handler(
        CallbackQueryHandler(handle_arab_pay_currency, pattern=r"^usdt_arab_pay_id_")
    )
    application.add_handler(
    CallbackQueryHandler(refund_last_withdraw, pattern="^refund_last_withdraw$")
    )
    application.add_handler(
    CallbackQueryHandler(refund_last_withdraw, pattern="^refund_last_withdraw$")
    )
    application.add_handler(
        CallbackQueryHandler(
            handle_usdt_withdraw_decision,
            pattern=r"^(approve_withdraw_usdt|reject_withdraw_usdt):"
        )
    )
    application.add_handler(CallbackQueryHandler(manual_referral_distribution, pattern="^manual_referral_distribution$"))
    application.add_handler(CallbackQueryHandler(distribute_ready_earnings, pattern="^distribute_ready_earnings$"))
    application.add_handler(CallbackQueryHandler(distribute_all_earnings, pattern="^distribute_all_earnings$"))
    application.add_handler(CallbackQueryHandler(confirm_distribute_ready, pattern="^confirm_distribute_ready$"))
    application.add_handler(CallbackQueryHandler(confirm_distribute_all, pattern="^confirm_distribute_all$"))
    application.add_handler(CallbackQueryHandler(show_earnings_details, pattern="^show_earnings_details$"))
    application.add_handler(
        CallbackQueryHandler(
            toggle_syriatel_number_visibility,
            pattern="^manage_syriatel_numbers$"
        )
    )
    application.add_handler(
        CallbackQueryHandler(
            handle_toggle_syriatel,
            pattern="^toggle_syriatel:\\d+$"
        )
    )
    application.add_handler(CallbackQueryHandler(manage_deposits_menu, pattern="^manage_deposits$"))
    application.add_handler(CallbackQueryHandler(toggle_deposit_method_callback, pattern="^toggle_deposit_"))



    # بدء تشغيل البوت مباشرة
    application.run_polling()




if __name__ == "__main__":
    main()
