# handlers/support/support_settings.py

from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes, ConversationHandler
# 🟢 استيراد الدالة الجديدة
from database import set_system_setting, get_system_setting 
# ❌ حذف: db, save_all_changes, load_db
from constants import AWAITING_SUPPORT_USERNAME
from handlers.admin.admin_menu import admin_panel_handler

async def set_support_account_start(update: Update, context: ContextTypes.DEFAULT_TYPE):
    # ❌ حذف load_db()
    
    query = update.callback_query
    await query.answer()
    
    keyboard = [[InlineKeyboardButton("🔙 العودة للوحة الأدمن", callback_data="cancel_support")]]
    reply_markup = InlineKeyboardMarkup(keyboard)

    
    await query.edit_message_text(
        "🛠️ الرجاء إرسال اسم مستخدم الدعم الجديد (مثال: @Luffy)\n\n"
        "**ملاحظة:** يمكنك الضغط على 'العودة' للإلغاء.", 
        reply_markup=reply_markup,
        parse_mode="Markdown" # 🟢 استخدام Markdown لتنسيق الملاحظة
    )
    return AWAITING_SUPPORT_USERNAME

async def receive_support_username(update: Update, context: ContextTypes.DEFAULT_TYPE):
    # ❌ حذف load_db()
    
    # ⚠️ ملاحظة: يجب إزالة المنطق الخاص بـ 'support_cancelled' من context.user_data
    # واستخدام إنهاء المحادثة (ConversationHandler.END) كإجراء وحيد في دالة الإلغاء.
    
    username_input = update.message.text.strip()

    if username_input.startswith('@'):
        username = username_input[1:]
    else:
        username = username_input

    if not username or len(username) < 3:
        await update.message.reply_text("❌ اسم المستخدم غير صالح. الرجاء المحاولة مجددًا.")
        return AWAITING_SUPPORT_USERNAME

    # 🟢 التعديل: استخدام دالة SQLite لتخزين الإعداد
    set_system_setting('support_username', username)
    # ❌ حذف save_all_changes()

    await update.message.reply_text(
        f"✅ تم تعيين حساب الدعم بنجاح إلى: @{username}\n"
        "يمكن للمستخدمين الآن التواصل معه عبر زر 'مراسلة الدعم'."
    )
    # 🟢 إزالة أي بيانات غير ضرورية بعد النجاح
    context.user_data.clear() 
    return ConversationHandler.END

async def cancel_set_support_account(update: Update, context: ContextTypes.DEFAULT_TYPE):
    # ❌ حذف load_db()
    query = update.callback_query
    await query.answer()

    # 🧹 تنظيف أي بيانات خاصة بالحالة
    context.user_data.clear()

    # 🔚 إنهاء المحادثة فعليًا
    await query.edit_message_text("❌ تم إلغاء عملية تعيين حساب الدعم.")
    
    # 👇 إعادة المستخدم إلى لوحة الأدمن بعد الإنهاء
    # ⚠️ يجب التأكد من أن admin_panel_handler لا يتطلب callback_query
    # إذا كانت الدالة تتطلب Update و Context فقط، فهذا صحيح.
    await admin_panel_handler(update, context)
    
    # 🟢 إرجاع ConversationHandler.END لإنهاء العملية الحوارية
    return ConversationHandler.END