from telegram import InlineKeyboardButton, InlineKeyboardMarkup, KeyboardButton, Update, WebAppInfo, ReplyKeyboardMarkup
from telegram.ext import ContextTypes, ConversationHandler , CallbackContext
from config import ADMIN_IDS, CHANNEL_USERNAME
from database import get_user_transactions , update_user_daily_wheel_usage , get_referral_relationships ,add_transaction,update_user_daily_wheel_usage, get_user_daily_wheel_usage, add_user_history, add_admin_history
from telegram.constants import ParseMode
import json
from datetime import datetime
import time
# from aiogram import Bot, Dispatcher, types # <-- هذا السطر غير مستخدم
from database import  get_net_deposit_last_24h, add_user_history, add_admin_history , get_bot_status
from database import (
    get_user_data,
    _get_setting,     # لجلب الإعدادات العامة (مثل المحظورين، الإحالات المعلقة)
    _set_setting,     # لتحديث الإعدادات العامة
    register_referral # لتسجيل الإحالة النهائية
    # ❌ تم حذف db, save_all_changes, load_db, save_data
)
from global_state import is_global_lock_active
async def check_subscription(user_id: int, context: ContextTypes.DEFAULT_TYPE) -> bool:
    try:
        chat_member = await context.bot.get_chat_member(chat_id=CHANNEL_USERNAME, user_id=user_id)
        return chat_member.status in ["member", "administrator", "creator"]
    except Exception as e:
        return False
    
async def check_subscription(user_id: int, context: ContextTypes.DEFAULT_TYPE) -> bool:
    try:
        chat_member = await context.bot.get_chat_member(chat_id=CHANNEL_USERNAME, user_id=user_id)
        return chat_member.status in ["member", "administrator", "creator"]
    except Exception as e:
        return False

# ⚠️ افتراض وجود دالة get_bot_status() لجلب حالة البوت من الإعدادات العامة
def get_bot_status() -> str:
    """جلب حالة البوت (running/stopped) باستخدام دوال SQLite."""
    # 🟢 التعديل: استخدام _get_setting
    return _get_setting('bot_status', 'running') 

# -------------------------------------------------------------------
# دالة start
# -------------------------------------------------------------------
    
async def start(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """أمر /start"""
    user = update.effective_user
    user_id = user.id
    user_id_str = str(user.id)
    
    # التحقق من الأقفال العامة والخاصة
    if is_global_lock_active():
        await update.message.reply_text(
            "⏳ النظام مشغول حاليًا. يرجى الانتظار 3 ثوانٍ ثم المحاولة مجددًا."
        )
        return ConversationHandler.END
    
    if context.user_data.get('withdraw_lock') or context.user_data.get('deposit_lock') or context.user_data.get('account_creation_lock'):
        await update.message.reply_text(
            "⚠️ جاري تنفيذ عملية أو إنشاء حساب حاليًا. لا يمكنك البدء مرة أخرى حتى اكتمال العملية."
        )
        return ConversationHandler.END

    # التحقق من حالة البوت
    if str(user_id_str) not in ADMIN_IDS:
        if get_bot_status() == "stopped":
            try:
                await update.message.reply_text(
                    "⛔ البوت متوقف مؤقتًا.\n"
                    "❗ يرجى المحاولة لاحقًا."
                )
            except:
                pass
            return ConversationHandler.END

    # === [الخطوة 1] استخراج كود الإحالة ===
    ref_parameter = None
    
    if context.args and len(context.args) > 0:
        arg = context.args[0]
        if arg.startswith("ref_"):
            ref_parameter = arg[4:].strip()
            print(f"🔗 كود إحالة من context.args: {ref_parameter}")

    elif update.message and update.message.text:
        text = update.message.text
        import re
        match = re.search(r'ref_(\d+)', text)
        if match:
            ref_parameter = match.group(1)
            print(f"🔗 كود إحالة من regex: {ref_parameter}")

    # === [الخطوة 2] حفظ الإحالة مؤقتاً إذا وجدت ===
    if ref_parameter and ref_parameter != "" and ref_parameter != user_id_str:
        # جلب pending_referrals
        raw_pending = _get_setting('pending_referrals', '{}')
        try:
            pending_referrals = json.loads(raw_pending) if raw_pending else {}
            if not isinstance(pending_referrals, dict):
                pending_referrals = {}
        except:
            pending_referrals = {}
        
        # حفظ الإحالة
        pending_referrals[user_id_str] = ref_parameter
        _set_setting('pending_referrals', json.dumps(pending_referrals))
        print(f"📝 تم حفظ الإحالة مؤقتاً: {user_id_str} -> {ref_parameter}")
        
        # رسالة تذكير للمستخدم
        if update.message:
            user_account = get_user_data(user_id_str)
            if not user_account:
                await update.message.reply_text(
                    "📋 **تم حفظ رابط الإحالة!**\n\n"
                    "لتفعيل الإحالة، يجب إنشاء حساب أولاً:\n"
                    "1️⃣ انقر على زر '➕ إنشاء حساب أيشانسي'\n"
                    "2️⃣ اتبع التعليمات\n"
                    "3️⃣ سيتم تفعيل الإحالة تلقائياً بعد إنشاء الحساب",
                    parse_mode='Markdown'
                )

    # === [الخطوة 3] التحقق من الحظر ===
    banned_users = _get_setting('banned_users', [])
    
    if user_id_str in banned_users:
        if update.message:
            await update.message.reply_text(
                "⛔ *لقد تم حظرك من استخدام هذا البوت.*\n"
                "للاستفسار، يرجى التواصل مع الدعم الفني.",
                parse_mode="Markdown"
            )
        return ConversationHandler.END

    # === [الخطوة 4] التحقق من الاشتراك ===
    # is_subscribed = await check_subscription(user_id, context)
    # if not is_subscribed:
    #     join_button = InlineKeyboardButton(
    #         "اضغط هنا للاشتراك 📣",
    #         url=f"https://t.me/{CHANNEL_USERNAME.lstrip('@')}"
    #     )
    #     markup = InlineKeyboardMarkup([[join_button]])
    #     await update.message.reply_text(
    #         "🔒 عليك الاشتراك في القناة الرسمية أولًا لاستخدام البوت!",
    #         reply_markup=markup
    #     )
    #     return ConversationHandler.END

    # === [الخطوة 5] معالجة الإحالة للمستخدمين الحاليين فقط ===
    # 🟢 جلب بيانات المستخدم
    user_account = get_user_data(user_id_str)
    
    # فقط إذا كان للمستخدم حساب موجود بالفعل
    if user_account:
        raw_pending = _get_setting('pending_referrals', '{}')
        try:
            pending_referrals = json.loads(raw_pending) if raw_pending else {}
        except:
            pending_referrals = {}

        if user_id_str in pending_referrals:
            referrer_id = pending_referrals[user_id_str]
            
            if str(referrer_id) != str(user_id_str):
                print(f"🎯 محاولة تسجيل إحالة لمستخدم موجود: {user_id_str} <- {referrer_id}")
                
                # 🟢 استدعاء بدون auto_create_user
                success = register_referral(user_id_str, referrer_id)
                
                if success:
                    print(f"✅ تم تسجيل إحالة بنجاح للمستخدم الموجود: {user_id_str} <- {referrer_id}")
                    
                    # إرسال إشعار للمُحيل
                    try:
                        await context.bot.send_message(
                            chat_id=int(referrer_id),
                            text=f"🎉 **مستخدم جديد أحلت له!**\n\n"
                                 f"👤 معرف المستخدم: {user_id_str}\n"
                                 f"📅 التاريخ: {datetime.now().strftime('%Y-%m-%d %H:%M')}\n\n"
                                 f"مبروك! سيتم احتساب أرباح الإحالة عند إيداعه."
                        )
                    except Exception as e:
                        print(f"⚠️ لم يتم إرسال إشعار للمُحيل {referrer_id}: {e}")
                
                # إزالة من القائمة المعلقة
                del pending_referrals[user_id_str]
                _set_setting('pending_referrals', json.dumps(pending_referrals))
                print(f"🗑️ تم إزالة الإحالة من pending_referrals: {user_id_str}")
    
    # === [الخطوة 6] محاولة تسجيل مباشرة للمستخدمين الحاليين ===
    if user_account and ref_parameter and ref_parameter != "" and ref_parameter != user_id_str:
        print(f"🎯 محاولة تسجيل إحالة مباشرة لمستخدم موجود: {user_id_str} <- {ref_parameter}")
        
        # 🟢 استدعاء بدون auto_create_user
        direct_success = register_referral(user_id_str, ref_parameter)
        
        if direct_success:
            print(f"✅ تم تسجيل الإحالة مباشرة بنجاح: {user_id_str} <- {ref_parameter}")

    # === [الخطوة 7] إلغاء أي عملية سابقة ===
    is_operation_active = (
        context.user_data.get("is_withdrawing")
        or context.user_data.get("is_depositing")
        or context.user_data.get("deposit_method")
    )

    if is_operation_active:
        if update.message:
            await update.message.reply_text("✅ تم إلغاء العملية السابقة بنجاح.")
        elif update.callback_query:
            await update.callback_query.answer()
            await update.callback_query.edit_message_text(
                "✅ تم إلغاء العملية السابقة بنجاح. يتم عرض القائمة الرئيسية...",
                parse_mode='HTML'
            )

        for key in ["is_withdrawing", "is_depositing", "deposit_method", "deposit_amount"]:
            context.user_data.pop(key, None)

    # === [الخطوة 8] عرض القائمة الرئيسية ===
    await show_main_menu(update, context)
    return ConversationHandler.END

def get_wheel_eligibility(user_id: str) -> int:
    from database import (
        get_user_data,
        get_net_deposit_last_24h,
        get_new_referrals_last_24h # 🟢 استخدام الدالة الجديدة
    )
    """
    [دالة معدّلة لـ SQLite]
    ترجع عدد الدورانات المسموح بها للمستخدم اليوم (0, 1, أو 2) بناءً على آخر 24 ساعة.
    """
    
    # 1. التحقق من وجود الحساب
    user_account = get_user_data(user_id)
    if not user_account:
        return 0  # لا يوجد حساب

    # 2. التحقق من الإيداع الشخصي (آخر 24 ساعة)
    net_deposit_self = get_net_deposit_last_24h(user_id) or 0

    # 3. التحقق من عدد الإحالات الجديدة اليوم
    new_referrals_rolling = get_new_referrals_last_24h(user_id)
    
    DEPOSIT_THRESHOLD = 50000 
    REFERRAL_THRESHOLD = 5

    deposit_condition = net_deposit_self >= DEPOSIT_THRESHOLD
    referral_condition = new_referrals_rolling >= REFERRAL_THRESHOLD

    if deposit_condition and referral_condition:
        return 2
    elif deposit_condition or referral_condition:
        return 1
    return 0

# ----------------------------------------------------
# [تم التعديل] تم تغيير منطق هذه الدالة بالكامل
# ----------------------------------------------------
def is_user_eligible_for_wheel(user_id: str) -> bool:
    from database import (
    get_user_data,
    get_user_daily_wheel_usage, # للحصول على الاستخدام اليومي
    # ❌ تم حذف load_db
    )
    """
    [دالة معدّلة لـ SQLite]
    يرجع True إذا كان المستخدم لديه دورانات متبقية "اليوم" (يوم تقويمي).
    """
    now = time.time()
    
    # 1. التحقق من وجود الحساب
    # 🟢 التعديل: استخدام get_user_data
    if not get_user_data(user_id):
        return False  # لا يوجد حساب

    # 2. كم عدد الدورانات التي يستحقها اليوم (0, 1, 2)؟
    # ⚠️ يجب التأكد من أن هذه الدالة تعمل مع SQLite (تم تعديلها في السؤال السابق)
    max_spins = get_wheel_eligibility(user_id)
    if max_spins == 0:
        return False # غير مؤهل أصلاً (لم يحقق شروط الإيداع/الإحالة)

    # 3. كم عدد الدورانات التي استخدمها في هذا "اليوم التقويمي"؟
    # 🟢 التعديل: استخدام دالة get_user_daily_wheel_usage
    last_day, spins_today = get_user_daily_wheel_usage(user_id)

    # إعادة ضبط العدّاد إذا بدأ يوم تقويمي جديد
    # ⚠️ حساب اليوم التقويمي بالثواني
    current_day = int(now // (24 * 3600)) 
    
    if last_day != current_day:
        spins_today = 0
        from database import update_user_daily_wheel_usage
        update_user_daily_wheel_usage(user_id, current_day, spins_today)
        # لا يتم الحفظ هنا، الحفظ يتم فقط عند اللعب الفعلي (لتجنب عمليات كتابة غير ضرورية)
    remaining_spins = max_spins - spins_today
    eligible = remaining_spins > 0

    # 4. هل لديه دورانات متبقية؟
    return eligible
# ----------------------------------------------------
# [تم التعديل] تم تعديل منطق رسالة العجلة
# ----------------------------------------------------
async def show_main_menu(update: Update, context: ContextTypes.DEFAULT_TYPE):
    user = update.effective_user
    user_id_str = str(user.id)
    last_day, spins_today = get_user_daily_wheel_usage(user.id)
    max_spins = get_wheel_eligibility(user.id)

    # ----------------------------------------
    # 1. معالجة كود الإحالة إذا موجود (تبقى كما هي)
    # ----------------------------------------
    ref_parameter = None
    if update.message and update.message.text:
        txt = update.message.text.strip()
        if txt.startswith("/start ref_"):
            try:
                # ❌ ملاحظة: يجب أن تتم معالجة الإحالة بالكامل في دالة start() 
                # بعد التحقق من الاشتراك (كما تم تعديلها في السؤال السابق)، 
                # لكن نترك هذا المنطق للحظة لتجنب كسر تسلسل البرنامج الأصلي.
                ref_parameter = txt.split("ref_")[1].strip()
            except:
                pass
    if ref_parameter:
        # 🟢 التعديل: استخدام دالة register_referral
        register_referral(user_id_str, ref_parameter)

    # ----------------------------------------
    # 2. تحضير نص الترحيب
    # ----------------------------------------
    welcome_text = "👋 أهلاً بك في البوت الرسمي ل **Ichancy**!\n\nاختر إحدى الخدمات أدناه:"

    # ----------------------------------------
    # 3. التحقق من وجود الحساب
    # ----------------------------------------
    # 🟢 التعديل: استخدام get_user_data للتحقق من وجود الحساب
    user_account = get_user_data(user_id_str) 
    
    if not user_account:
        # المستخدم ليس لديه حساب
        keyboard = [
            [InlineKeyboardButton("➕ إنشاء حساب أيشانسي", callback_data="my_account")],
            [InlineKeyboardButton("📄 دليل المستخدم و شروط البوت", callback_data="terms_conditions")]
        ]
        markup = InlineKeyboardMarkup(keyboard)
        
        # ❌ منطق الرد على الرسالة/الـ Callback Query يظل كما هو
        if update.callback_query:
            await update.callback_query.answer()
            await update.callback_query.edit_message_text(
                welcome_text,
                reply_markup=markup,
                parse_mode="Markdown"
            )
        else:
            await update.message.reply_text(
                welcome_text,
                reply_markup=markup,
                parse_mode="Markdown"
            )
        return

    # ----------------------------------------
    # 4. المستخدم لديه حساب (منطق العجلة)
    # ----------------------------------------
    WHEEL_URL = "https://luffy-wheel.clay-code.dev/wheel.html"
    
    # حساب اللفات مرة واحدة
    # رسالة تذكير العجلة
    msg = ""
    # ⚠️ يجب التأكد أن الدالة تعمل مع SQLite
    if is_user_eligible_for_wheel(user_id_str):
        # ⚠️ يجب التأكد أن الدالة تعمل مع SQLite
        max_spins = get_wheel_eligibility(user_id_str) 
        
        # 🟢 التعديل: استخدام دالة get_user_daily_wheel_usage
        last_day, spins_today = get_user_daily_wheel_usage(user_id_str)
        current_day = int(time.time() // (24 * 3600))
        
        # إعادة ضبط العدد إذا كان يوم جديد (بدون حفظ في DB هنا)
        if last_day != current_day:
            spins_today = 0
            update_user_daily_wheel_usage(user_id_str, current_day, spins_today)
            
        remaining_spins = max(0, max_spins - spins_today)
        
        if remaining_spins > 0:
            msg = f"\n\n🎯 *تنبيه العجلة:* لديك {remaining_spins} دورة متبقية اليوم."
            
        


    final_text = welcome_text + msg

    
    # ----------------------------------------
    # 5. لوحة الأزرار الرئيسية
    # ----------------------------------------
    keyboard = [
        [InlineKeyboardButton("Ichancy", callback_data="ishansy_menu")],
        [InlineKeyboardButton("💰 شحن البوت ", callback_data="deposit"),
         InlineKeyboardButton("💸 سحب من البوت", callback_data="withdraw")],
        [InlineKeyboardButton("👤 معلومات الملف الشخصي ", callback_data="my_account")],
        [InlineKeyboardButton("🎁  كود هدية", callback_data="promo_menu_user")],
        [InlineKeyboardButton("🎁 اهداء رصيد", callback_data="gift_balance"),
         InlineKeyboardButton("💼 محفظتي", callback_data="wallet")],
        [InlineKeyboardButton("👥 الإحالات", callback_data="referrals"),
         InlineKeyboardButton("📄 عرض السجل المالي", callback_data="show_my_transactions")],
        [InlineKeyboardButton("🎮 لعبة الصناديق", callback_data="game"),
         InlineKeyboardButton("💬 مراسلة الدعم", callback_data="support")],
        [InlineKeyboardButton(
            " Golden Tree ",
            url="https://www.ichancy.com/slots/all/36/pascal-gaming/77612-500008078-golden-tree:-buy-bonus?mode=real"
        )],
        [InlineKeyboardButton("💸 استرداد آخر طلب سحب", callback_data="refund_last_withdraw")],
        [InlineKeyboardButton("📜 دليل المستخدم وشروط البوت ", callback_data="terms_conditions")]
    ]
    if str(user.id) in map(str, ADMIN_IDS):
        keyboard.append([InlineKeyboardButton("⚙️ لوحة الأدمن", callback_data="admin_panel")])

    main_markup = InlineKeyboardMarkup(keyboard)


    # 6. زر العجلة WebApp (يتم حساب اللفات مجدداً هنا)
    # ----------------------------------------
    # 6. زر العجلة WebApp (تعديل المنطق لضمان التحديث)
    # ----------------------------------------
    
    # حساب اللفات الحالية
    current_max_spins = get_wheel_eligibility(user_id_str)
    last_day, spins_today = get_user_daily_wheel_usage(user_id_str)
    current_day = int(time.time() // (24 * 3600))

    if last_day != current_day:
        spins_today = 0
        update_user_daily_wheel_usage(user_id_str, current_day, spins_today)
    
    current_remaining = max(0, current_max_spins - spins_today)

    # التحقق: هل تغير عدد اللفات عما أرسلناه سابقاً؟
    last_sent_spins = context.user_data.get("last_sent_spins", -1)
    should_refresh_keyboard = current_remaining != last_sent_spins

    if current_remaining > 0:
        wheel_button = [[KeyboardButton(f"🎡 العجلة ({current_remaining} لفات متبقية)", web_app=WebAppInfo(url=WHEEL_URL))]]
    else:
        wheel_button = [[KeyboardButton("🎡 العجلة (0 لفة) – غير متاح ❌")]]
    
    wheel_markup = ReplyKeyboardMarkup(wheel_button, resize_keyboard=True)

    # ----------------------------------------
    # 7. إرسال أو تعديل الرسائل
    # ----------------------------------------
    if update.callback_query:
        await update.callback_query.answer()
        await update.callback_query.edit_message_text(
            final_text,
            parse_mode="Markdown",
            reply_markup=main_markup
        )
        
        # إذا تغير عدد اللفات، نرسل رسالة جديدة لتحديث الكيبورد
        if should_refresh_keyboard:
            await update.effective_chat.send_message(
                f"🔄 تم تحديث حالة العجلة: لديك {current_remaining} لفة متاح الآن.",
                reply_markup=wheel_markup
            )
            context.user_data["last_sent_spins"] = current_remaining
            context.user_data["wheel_button_sent"] = True
        return

    # في حالة الرسالة العادية (/start)
    await update.message.reply_text(
        final_text,
        reply_markup=main_markup,
        parse_mode="Markdown"
    )
    
    if should_refresh_keyboard:
        await update.message.reply_text(
            "🎡 العجلة متاحة عبر الزر أدناه:",
            reply_markup=wheel_markup
        )
        context.user_data["last_sent_spins"] = current_remaining
        context.user_data["wheel_button_sent"] = True

# ----------------------------------------------------
# [تم التعديل] تم تحسين رسالة الفوز
# ----------------------------------------------------
async def handle_web_app_data(update: Update, context: ContextTypes.DEFAULT_TYPE):
    user_id = str(update.effective_user.id)
    now = time.time()

    # 1. جلب بيانات المستخدم
    user_account = get_user_data(user_id)
    if not user_account:
        return

    # 2. التحقق من الأهلية القصوى
    max_spins = get_wheel_eligibility(user_id)
    if max_spins == 0:
        msg = "🚫 أنت غير مؤهل للعب العجلة اليوم. (إيداع 50,000 أو 5 إحالات نشطة خلال 24س)"
        await update.message.reply_text(msg)
        return

    # 3. عدد الدورانات المستخدمة اليوم
    last_day, spins_today = get_user_daily_wheel_usage(user_id)
    current_day = int(now // (24*3600))
    
    if last_day != current_day:
        spins_today = 0
        
    if spins_today >= max_spins:
        msg = f"🎯 لقد استنفدت عدد الدورانات المتاحة لك اليوم ({spins_today}/{max_spins})!"
        await update.message.reply_text(msg)
        return

    # 4. معالجة النتيجة من الـ WebApp
    try:
        data = json.loads(update.message.web_app_data.data)
        prize_value = float(data.get("result", 0))
    except Exception as e:
        await update.message.reply_text("حدث خطأ في معالجة النتيجة.")
        return
        
    new_spins_used = spins_today + 1

    # إضافة الجائزة للسجل والرصيد
    if prize_value > 0:
        from database import add_transaction
        add_transaction(
            user_id=user_id,
            tx_type="wheel_win",
            amount=prize_value,
            method="spin_wheel",
            status="success",
            metadata={"source": "wheel_game"}
        )
        
    # 5. تحديث قاعدة البيانات
    update_user_daily_wheel_usage(user_id, current_day, new_spins_used) 

    # --- 🟢 تحديث واجهة المستخدم (الأزرار) 🟢 ---
    remaining_after_spin = max(0, max_spins - new_spins_used)
    
    # تحديث الذاكرة المؤقتة لضمان مزامنة القائمة الرئيسية لاحقاً
    context.user_data["last_sent_spins"] = remaining_after_spin
    context.user_data["wheel_button_sent"] = True

    # تحضير الزر المحدث
    WHEEL_URL = "https://luffy-wheel.clay-code.dev/wheel.html"
    if remaining_after_spin > 0:
        wheel_button = [[KeyboardButton(f"🎡 العجلة ({remaining_after_spin} لفات متبقية)", web_app=WebAppInfo(url=WHEEL_URL))]]
    else:
        wheel_button = [[KeyboardButton("🎡 العجلة (0 لفة) – غير متاح ❌")]]
    
    wheel_markup = ReplyKeyboardMarkup(wheel_button, resize_keyboard=True)

    # 6. رسالة التأكيد مع الكيبورد الجديد
    win_msg = f"🎉 مبروك! ربحت {prize_value:,.0f} ل.س." if prize_value > 0 else "😅 لم تربح هذه المرة، حاول مجددًا!"
    if remaining_after_spin > 0:
        win_msg += f"\n\n🎯 تبقى لديك {remaining_after_spin} دورة إضافية اليوم."
    else:
        win_msg += "\n\nلقد استنفدت جميع دوراتك لهذا اليوم. نراك غداً!"

    await update.message.reply_text(win_msg, reply_markup=wheel_markup)

async def back_to_main_menu(update, context):
    
    """العودة إلى القائمة الرئيسية"""
    if update.callback_query:
        await update.callback_query.answer()
    # يتم استدعاء start الذي يعالج الحالتين (message or callback)
    await start(update, context) 
    return ConversationHandler.END

# ----------------------------------------------------
# [تم التعديل] تم تعديل نص الشروط
# ----------------------------------------------------
async def show_terms(update: Update, context: CallbackContext):
    
    query = update.callback_query
    await query.answer()  # إغلاق الـ loading على الزر

    terms_text = (
        "📜 *الشروط والأحكام لاستخدام بوت Ichancy* 📜\n\n"
        "عند الضغط على زر *موافقة*، فأنت توافق على الشروط التالية:\n\n"
        
        "💡 *مقدمة:*\n"
        "البوت مخصّص لإنشاء الحسابات، والسّحب، والتعبئة الفورية لحسابات موقع Ichancy.\n\n"
        
        "1️⃣ *طريقة استخدام عجلة الحظ:*\n"
        "يحصل المستخدم على *ضربة عجلة واحدة* عند إكمال أحد الخيارين التاليين (خلال آخر 24 ساعة):\n"
        "(أ) تعبئة رصيد بقيمة 50,000 ل.س أو ما يعادلها.\n"
        "(ب) إحالة 5 مستخدمين نشطين قاموا فعلياً بالتعبئة على البوت.\n"
        "في حال تحقيق *كلا الشرطين* معاً (خلال آخر 24 ساعة)، يحصل المستخدم على *دورة ثانية* (بمجموع دورتين في اليوم).\n"
        "يتم تصفير عداد الدورات يومياً (حسب اليوم التقويمي).\n"
        "⚠️ ملاحظة: دور العجلة التجريبي لا يؤثر على رصيد الحساب — أي أرباح من الدور التجريبي لا تُضاف الى الرصيد الفعلي.\n\n"
        
        "2️⃣ *مصداقية البوت:*\n"
        "البوت رسمي ومعتمد من إدارة موقع Ichancy، ويعمل بخوارزميات دقيقة لضمان تجربة موثوقة وآمنة للمستخدمين.\n\n"
        
        "3️⃣ *شروط أرباح الإحالات:*\n"
        "تُحتسب أرباح الإحالة فقط بعد تسجيل 3 إحالات نشطة أو أكثر (أي قاموا بالتعبئة الفعلية).\n\n"
        
        "4️⃣ *نظام السحب:*\n"
        "يقوم البوت باقتصاص تكاليف تشغيلية كنسبة قدرها 5% لعمليات السحب القادمة من أرباح الموقع.\n\n"
        
        "5️⃣ *تبديل طرق الدفع (ممنوع):*\n"
        "لا يسمح بشحن رصيد وسحبه بهدف التبديل بين وسائل الدفع المختلفة.\n"
        "إذا تم اكتشاف هكذا عملية، سيتم سحب الرصيد والتحفظ عليه دون إشعار مسبق. البوت ليس منصة تحويل عملات/مدفوعات.\n\n"
        
        "⛔️ *تنبيه:*\n"
        "أي محاولة للتحايل أو مخالفة الشروط ستؤدي إلى إيقاف الحساب وتجميد الأرصدة.\n\n"
        
        "📌 يرجى قراءة هذه الشروط بعناية لضمان تجربة آمنة وسلسة."
    )


    # إنشاء أزرار InlineKeyboard
    keyboard = [
        [InlineKeyboardButton("✅ موافق", callback_data="accept_terms")],
        [InlineKeyboardButton("🔙 رجوع للقائمة الرئيسية", callback_data="back_to_main")]
    ]
    markup = InlineKeyboardMarkup(keyboard)

    # إرسال رسالة الشروط
    await query.message.reply_text(
        terms_text,
        reply_markup=markup,
        parse_mode=ParseMode.MARKDOWN
    )

async def accept_terms_handler(update: Update, context: CallbackContext):
    query = update.callback_query
    await query.answer()  # إغلاق الـ loading على الزر
    await query.message.reply_text(
        "✅ شكراً لموافقتك على الشروط! يمكنك الآن استخدام جميع ميزات البوت."
    )
    # يمكن إعادة توجيه المستخدم للقائمة الرئيسية
    await back_to_main_menu(update, context)

async def show_eagle_info(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """إظهار معلومات الحساب فقط عند الضغط على زر Ichancy (أو ما شابه)"""
    user = update.effective_user
    user_id_str = str(user.id)
    now = time.time()
    
    # 🟢 التعديل: جلب بيانات المستخدم من SQLite
    user_account = get_user_data(user_id_str)
    
    if not user_account:
        # ⚠️ إذا كان الزر لا يظهر إلا بوجود حساب، فهذه الحالة نادرة
        if update.callback_query:
            await update.callback_query.answer("⚠️ لا يوجد لديك حساب!", show_alert=True)
            return
        elif update.message:
            await update.message.reply_text("⚠️ لا يوجد لديك حساب!")
            return

    balance = user_account.get("balance", 0)
    bonus_balance = user_account.get("bonus_balance", 0)

    # ----------------------------------------------------
    # 🔹 معلومات العجلة (اللفات اليومية) - المنطق الجديد
    # ----------------------------------------------------
    
    # 1. جلب بيانات الاستخدام اليومي من DB
    # 🟢 التعديل: استخدام دالة get_user_daily_wheel_usage
    last_day, spins_today = get_user_daily_wheel_usage(user_id_str)

    # 2. إعادة ضبط العد إذا تغير اليوم (للعرض فقط)
    current_day = int(now // (24 * 3600))
    if last_day != current_day:
        spins_today = 0

    # 3. تحقق من الأهلية القصوى
    max_spins = get_wheel_eligibility(user_id_str)

    if max_spins == 0:
        # 4. حساب الشروط المتبقية لعدم الأهلية
        DEPOSIT_THRESHOLD = 0
        REFERRAL_THRESHOLD = 5
        
        # 🟢 التعديل: استخدام الدالة المعدلة لـ SQLite
        net_deposit = get_net_deposit_last_24h(user_id_str) or 0
        remaining_amount = max(0, DEPOSIT_THRESHOLD - net_deposit)
        
        # 🟢 التعديل: جلب علاقات الإحالة من SQLite
        referral_relationships = get_referral_relationships()
        
        active_referrals = sum(
            1 
            for invited_id, referrer_id in referral_relationships.items()
            if referrer_id == user_id_str and (get_net_deposit_last_24h(invited_id) or 0) > 0
        )
        remaining_refs = max(0, REFERRAL_THRESHOLD - active_referrals)
        
        # 5. بناء رسالة حالة العجلة لغير المؤهلين
        wheel_status = "🚫 لا يمكنك اللعب بعد (الشروط لآخر 24س):\n"
        
        # عرض الشرط الأول: الإيداع
        if remaining_amount > 0:
             wheel_status += f"🔸 تحتاج لإيداع {remaining_amount:,.0f} ل.س إضافية\n"
        else:
             wheel_status += f"✅ تم تحقيق شرط الإيداع (آخر 24س)\n"

        # عرض الشرط الثاني: الإحالات
        if remaining_refs > 0:
             wheel_status += f"🔸 تحتاج {remaining_refs} إحالة نشطة إضافية"
        else:
             wheel_status += f"✅ تم تحقيق شرط الإحالات (آخر 24س)"
            
    else:
        # 6. بناء رسالة حالة العجلة للمؤهلين
        remaining_spins = max(0, max_spins - spins_today)
        if remaining_spins <= 0:
            wheel_status = "🎯 لقد استنفدت عدد الدورانات المتاحة لك اليوم!"
        else:
            wheel_status = f"🎡 لديك {remaining_spins} ضربة عجلة متاحة اليوم! يمكنك تجربتها الآن 🎯"

    # ----------------------------------------------------
    # 7. بناء الرسالة النهائية وإرسالها
    # ----------------------------------------------------
    text = (
        f"🦅 **معلومات حسابك في Ichancy:**\n\n"
        f"🆔 **معرفك:** `{user.id}`\n"
        f"💰 **الرصيد:** {int(balance):,} ل.س\n"
        f"🎁 **هدايا:** {int(bonus_balance):,} ل.س\n\n"
        f"🎡 **حالة لعبة العجلة:**\n{wheel_status}\n\n"
        f"✨ استخدم القائمة أدناه لاختيار العمليات."
    )

    keyboard = [
        [InlineKeyboardButton("💰 شحن", callback_data="deposit"),
         InlineKeyboardButton("💸 سحب", callback_data="withdraw")],
        [InlineKeyboardButton("🔙 العودة للقائمة الرئيسية", callback_data="back_to_main")]
    ]
    reply_markup = InlineKeyboardMarkup(keyboard)

    if update.callback_query:
        await update.callback_query.answer()
        await update.callback_query.edit_message_text(
            text=text,
            reply_markup=reply_markup,
            parse_mode="Markdown"
        )
    elif update.message:
        await update.message.reply_text(
            text,
            reply_markup=reply_markup,
            parse_mode="Markdown"
        )

# ----------------------------------------------------
# [تم التعديل] تمت إضافة سجل العجلة
# ----------------------------------------------------
async def show_my_transactions(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """عرض السجل المالي (اختيار بين سجل السحب أو الإيداع)"""
    query = update.callback_query
    await query.answer()

    text = "📄 اختر نوع السجل الذي ترغب بعرضه:"

    keyboard = [
        [InlineKeyboardButton("📤 سجل السحب", callback_data="withdraw_history"),
         InlineKeyboardButton("💵 سجل الإيداع", callback_data="deposit_history")],
        [InlineKeyboardButton("🔙 العودة للقائمة الرئيسية", callback_data="back_to_main")]
    ]

    await query.edit_message_text(
        text=text,
        reply_markup=InlineKeyboardMarkup(keyboard)
    )

# ----------------------------------------------------
# 2. سجل السحب (تم التعديل)
# ----------------------------------------------------
async def show_withdraw_history(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    user_id = str(update.effective_user.id)
    # 🟢 التعديل: جلب سجلات السحب مباشرة من SQLite
    logs = get_user_transactions(user_id, 'withdraw') 

    history = []
    for tx in logs:
        # لم يعد هناك حاجة لفحص user_id أو tx_type بفضل استعلام SQL
        amount = tx.get('amount', 0)
        status = tx.get('status', 'pending')
        method = tx.get('method', 'N/A')
        
        try:
            timestamp = datetime.fromtimestamp(tx.get('timestamp', time.time())).strftime('%Y-%m-%d %H:%M')
        except:
            timestamp = 'غير معروف'
            
        history.append(
            f"📤 المبلغ: <code>{amount:,.0f}</code> - طريقة السحب: <b>{method}</b> - الحالة: <b>{status}</b> - {timestamp}"
        )

    if history:
        text = "📤 <b>سجل السحب الخاص بك:</b>\n\n" + "\n".join(history)
    else:
        text = "🚫 لا يوجد سجل سحب حتى الآن."

    keyboard = [[InlineKeyboardButton("🔙 العودة", callback_data="show_my_transactions")]]
    
    await query.edit_message_text(
        text=text,
        reply_markup=InlineKeyboardMarkup(keyboard),
        parse_mode="HTML"
    )

# ----------------------------------------------------
# 3. سجل الإيداع (تم التعديل)
# ----------------------------------------------------
async def show_deposit_history(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    user_id = str(update.effective_user.id)
    # 🟢 التعديل: جلب سجلات الإيداع مباشرة من SQLite
    logs = get_user_transactions(user_id, 'deposit') 

    deposits = []
    for tx in logs:
        # لم يعد هناك حاجة لفحص user_id أو tx_type بفضل استعلام SQL
        amount = tx.get('amount', 0)
        method = tx.get('method', 'N/A')
        
        try:
            timestamp = datetime.fromtimestamp(tx.get('timestamp', time.time())).strftime('%Y-%m-%d %H:%M')
        except:
            timestamp = 'غير معروف'
            
        deposits.append(f"💵 المبلغ: <code>{amount:,.0f}</code> ل.س - الطريقة: <b>{method}</b> - {timestamp}")

    if deposits:
        text = "💵 <b>سجل الإيداع الخاص بك:</b>\n\n" + "\n".join(deposits)
    else:
        text = "🚫 لا يوجد سجل إيداع حتى الآن."

    keyboard = [[InlineKeyboardButton("🔙 العودة", callback_data="show_my_transactions")]]
    await query.edit_message_text(
        text=text,
        reply_markup=InlineKeyboardMarkup(keyboard),
        parse_mode="HTML"
    )

# ----------------------------------------------------
# 4. سجل أرباح العجلة (تم التعديل)
# ----------------------------------------------------
async def show_wheel_history(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """عرض سجل أرباح العجلة"""
    query = update.callback_query
    await query.answer()

    user_id = str(update.effective_user.id)
    # 🟢 التعديل: جلب سجلات أرباح العجلة مباشرة من SQLite
    logs = get_user_transactions(user_id, 'wheel_win') 

    history = []
    for tx in logs:
        # لم يعد هناك حاجة لفحص user_id أو tx_type بفضل استعلام SQL
        try:
            timestamp = datetime.fromtimestamp(tx.get('timestamp', time.time())).strftime('%Y-%m-%d %H:%M')
        except:
            timestamp = 'غير معروف'

        amount = tx.get('amount', 0)
        history.append(f"🎁 {amount:,.0f} ل.س - {timestamp}")
    
    if history:
        text = "🎁 *سجل أرباحك من العجلة:*\n\n" + "\n".join(history)
    else:
        text = "🚫 لا يوجد أرباح من العجلة حتى الآن."

    keyboard = [[InlineKeyboardButton("🔙 العودة", callback_data="show_my_transactions")]]
    await query.edit_message_text(text=text, reply_markup=InlineKeyboardMarkup(keyboard), parse_mode="Markdown")