from telegram import InlineKeyboardButton, InlineKeyboardMarkup, Update
from telegram.ext import ContextTypes, ConversationHandler
from database import (
   
    create_pending_deposit

)
from config import get_config, ADMIN_IDS, OPERATIONS_CHANNEL_ID

from constants import AWAITING_DEPOSIT_SYRIATEL_NUMBER, AWAITING_DEPOSIT_SYRIATEL_AMOUNT

# --- زر الإلغاء ---
def get_cancel_button():
    return [InlineKeyboardButton("❌ إلغاء العملية", callback_data="cancel_deposit_syriatel")]

CANCEL_NOTE = "\n\n⚠️ <b>ملاحظة:</b> يرجى إلغاء العملية قبل الضغط على أي زر آخر لتجنب تعارض الطلبات."

# --- إلغاء العملية ---
async def cancel_deposit_syriatel(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    context.user_data.clear()
    await query.edit_message_text("❌ تم إلغاء عملية الإيداع.", parse_mode='HTML')
    return ConversationHandler.END

# --- بدء العملية ---
async def deposit_syriatel_start(update: Update, context: ContextTypes.DEFAULT_TYPE):
    context.user_data.clear()
    context.user_data["is_depositing"] = True

    query = update.callback_query
    await query.answer()

    await query.edit_message_text(
        "🔢 الرجاء إدخال <b>رقم العملية</b> التي ظهرت لك بعد إرسال الحوالة.\n"
        "مثال: 600123456789" + CANCEL_NOTE,
        reply_markup=InlineKeyboardMarkup([get_cancel_button()]),
        parse_mode='HTML'
    )
    return AWAITING_DEPOSIT_SYRIATEL_NUMBER

# --- استلام رقم العملية ---
async def receive_deposit_syriatel_number(update: Update, context: ContextTypes.DEFAULT_TYPE):
    operation_code = update.message.text.strip()

    # التحقق من أن المستخدم أدخل أرقام فقط
    if not operation_code.isdigit():
        await update.message.reply_text("❌ رقم العملية غير صالح. يجب أن يتكون من أرقام فقط.")
        return AWAITING_DEPOSIT_SYRIATEL_NUMBER

    # تخزين رقم العملية
    context.user_data["operation_code"] = operation_code

    await update.message.reply_text(
        "💰 الآن أرسل المبلغ الذي تريد إيداعه:" + CANCEL_NOTE,
        reply_markup=InlineKeyboardMarkup([get_cancel_button()]),
        parse_mode='HTML'
    )
    return AWAITING_DEPOSIT_SYRIATEL_AMOUNT

# --- استلام المبلغ وإنشاء طلب إيداع معلّق ---
# --- استلام المبلغ وإنشاء طلب إيداع معلّق ---
async def receive_deposit_syriatel_amount(update: Update, context: ContextTypes.DEFAULT_TYPE):
    user_id = str(update.effective_user.id)
    operation_code = context.user_data.get("operation_code")

    if not operation_code:
        await update.message.reply_text("❌ حدث خلل، يرجى البدء من جديد.")
        return ConversationHandler.END

    try:
        amount = int(update.message.text.strip())
        if amount <= 0:
            raise ValueError
    except ValueError:
        await update.message.reply_text("❌ مبلغ غير صالح. الرجاء إرسال رقم موجب صحيح.")
        return AWAITING_DEPOSIT_SYRIATEL_AMOUNT

    # الحد الأدنى للإيداع
    config = get_config()
    MIN_DEPOSIT = config.get("MINIMUM_DEPOSIT", {}).get("SYRIATEL", 10_000)

    if amount < MIN_DEPOSIT:
        await update.message.reply_text(f"❌ الحد الأدنى للإيداع هو {MIN_DEPOSIT:,} ل.س.")
        return AWAITING_DEPOSIT_SYRIATEL_AMOUNT

    # إنشاء الطلب المعلّق فقط (بدون إضافة رصيد وبدون سجل معاملة)
    request_id = create_pending_deposit(
        user_id=user_id,
        operation_code=operation_code,   # ← رقم العملية
        amount=amount,
        method="syriatel"
       
    )

    if not request_id:
        await update.message.reply_text("❌ حدث خلل أثناء إنشاء طلب الإيداع.")
        return ConversationHandler.END

    # رسالة تأكيد للمستخدم
    await update.message.reply_text(
        f"✅ تم تقديم طلب الإيداع بنجاح!\n\n"
        f"• المبلغ: {amount:,} ل.س\n"
        f"• رقم العملية: {operation_code}\n"
        f"• حالة الطلب: ⏳ بانتظار موافقة الإدارة\n",
        parse_mode="HTML"
    )

    # إشعار الأدمن
    msg = (
        f"🆕 <b>طلب إيداع جديد:</b>\n"
        f"👤 المستخدم: <code>{user_id}</code>\n"
        f"💰 المبلغ: {amount:,} ل.س\n"
        f"📄 رقم العملية: <code>{operation_code}</code>\n"
        f"📌 الحالة: ⏳ قيد المراجعة\n"
        f"🔗 معرف الطلب: <code>{request_id}</code>"
    )

    keyboard = [
        [
            InlineKeyboardButton("✅ الموافقة", callback_data=f"approve_deposit:{request_id}"),
            InlineKeyboardButton("❌ الرفض", callback_data=f"reject_deposit:{request_id}")
        ]
    ]

    # إرسال إلى الأدمن
    for admin in ADMIN_IDS:
        try:
            await context.bot.send_message(
                chat_id=admin,
                text=msg,
                parse_mode="HTML",
                reply_markup=InlineKeyboardMarkup(keyboard)
            )
        except Exception as e:
            print(f"خطأ إرسال للإدارة: {e}")

    # إرسال إلى قناة العمليات
    if OPERATIONS_CHANNEL_ID:
        try:
            await context.bot.send_message(
                chat_id=OPERATIONS_CHANNEL_ID,
                text=msg,
                parse_mode="HTML"
            )
        except:
            pass

    context.user_data.clear()
    return ConversationHandler.END
