from telegram import User
from telegram.ext import ContextTypes
from config import OPERATIONS_CHANNEL_ID, PAYMENT_METHODS

async def send_deposit_notification(context: ContextTypes.DEFAULT_TYPE, user, status: str, amount: float, method: str, client_number: str, details: str = ""):
    # ❌ تم حذف: db = load_db()
    """
    إرسال إشعار بحالة الإيداع إلى قناة العمليات
    """
    # ⚠️ يفترض أن الثوابت (OPERATIONS_CHANNEL_ID و PAYMENT_METHODS) 
    # تم استيرادها بشكل صحيح في بداية ملفك
    if not OPERATIONS_CHANNEL_ID:
        print("⚠️ OPERATIONS_CHANNEL_ID is not set. Skipping notification.")
        return

    user_mention = user.mention_html()
    username = f"@{user.username}" if user.username else "N/A"
    # يتم استخدام المتغير method_name كما هو في الكود الأصلي، 
    # مع افتراض أن PAYMENT_METHODS هو قاموس مُستورد
    method_name = PAYMENT_METHODS.get(method, method)
    
    if status == "SUCCESS":
        icon = "✅"
        title = "إيداع ناجح (آلي)"
        message = (
            f"{icon} <b>{title}</b>\n\n"
            f"👤 <b>المستخدم:</b> {user_mention} (<code>{user.id}</code>)\n"
            f"📧 <b>المعرف:</b> {username}\n"
            f"💰 <b>المبلغ:</b> <code>{int(amount):,}</code> ل.س\n"
            f"💳 <b>الطريقة:</b> {method_name}\n"
            f"🧾 <b>رقم العملية:</b> <code>{client_number}</code>"
        )
    elif status == "FAILED":
        icon = "❌"
        title = "فشل إيداع (آلي)"
        message = (
            f"{icon} <b>{title}</b>\n\n"
            f"👤 <b>المستخدم:</b> {user_mention} (<code>{user.id}</code>)\n"
            f"📧 <b>المعرف:</b> {username}\n"
            f"💳 <b>الطريقة:</b> {method_name}\n"
            f"🧾 <b>الرقم المدخل:</b> <code>{client_number}</code>\n"
            f"🚫 <b>السبب:</b> {details}"
        )
    elif status == "DUPLICATE":
        icon = "⚠️"
        title = "محاولة تكرار عملية إيداع"
        message = (
            f"{icon} <b>{title}</b>\n\n"
            f"👤 <b>المستخدم:</b> {user_mention} (<code>{user.id}</code>)\n"
            f"📧 <b>المعرف:</b> {username}\n"
            f"💳 <b>الطريقة:</b> {method_name}\n"
            f"🧾 <b>الرقم المكرر:</b> <code>{client_number}</code>"
        )
    elif status == "FRAUD":
        icon = "🚨"
        title = "محاولة احتيال مكتشفة"
        message = (
            f"{icon} <b>{title}</b>\n\n"
            f"👤 <b>المستخدم:</b> {user_mention} (<code>{user.id}</code>)\n"
            f"💳 <b>الطريقة:</b> {method_name}\n"
            f"🧾 <b>الرقم المشبوه:</b> <code>{client_number}</code>\n"
            f"⚠️ <b>التفاصيل:</b> {details}"
        )

    else:
        return # لا ترسل إشعار لحالات أخرى مثل حوالة قيد الانتظار

    try:
        await context.bot.send_message(
            chat_id=OPERATIONS_CHANNEL_ID,
            text=message,
            parse_mode='HTML'
        )
    except Exception as e:
        print(f"❌ خطأ في إرسال إشعار للقناة: {e}")
    
