import re
from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes, ConversationHandler
# ❌ تم إزالة: from database import db, save_all_changes, load_db
# 🟢 تم تحديث الاستيراد لاستخدام دوال SQLite النظيفة:
from database import create_local_user, get_user_data, get_net_deposit_last_24h, _get_setting 
import time
from global_state import activate_global_lock
import asyncio
from ishansy_controller import IshansyController
from constants import AWAITING_USERNAME_INPUT, AWAITING_PASSWORD_INPUT
from config import OPERATIONS_USERS_ID
import json
from datetime import datetime
from database import _get_setting, _set_setting, register_referral
try:
    # ⚠️ يجب التأكد أن get_wheel_eligibility تم تعديلها لاستخدام دوال database الجديدة
    from handlers.menu.main_menu import get_wheel_eligibility
except ImportError:
    print("[ERROR] لا يمكن استيراد get_wheel_eligibility. استخدام دالة بديلة.")
    def get_wheel_eligibility(user_id: str): return 0 


# --- دالة متزامنة لتشغيل إنشاء حساب الموقع ---
def _run_ishansy_account_creation_sync(proposed_username: str, password_input: str):
    """
    إنشاء حساب جديد عبر API الرسمي الجديد.
    لا يستخدم متصفح أو كوكيز — فقط login + registerPlayer.
    """

    controller = IshansyController(
        username="luffy@gmail.com",
        password="Aa@723723"
    )

    # 1️⃣ تسجيل الدخول (SignIn API)
    success, resp = controller.login()
    if not success:
        return False, None, None, f"❌ فشل تسجيل الدخول API: {resp}"

    # 2️⃣ بناء بيانات إنشاء اللاعب الجديد
    email = f"{proposed_username}@gmail.com"
    parent_id = controller.username  # إذا الموقع يتطلب parentId = ايميل الوكيل
    new_password = password_input

    # 3️⃣ إرسال الطلب الحقيقي لإنشاء اللاعب
    result = controller.register_player(
        email=email,
        password=new_password,
        parent_id=2618500,         # إذا بدك خليها 0 — حسب نظام الموقع
        username=proposed_username
    )

    # 4️⃣ التحقق من نجاح العملية
    if result.get("status") is True:
        return True, proposed_username, email, new_password

    # 5️⃣ اسم مستخدم مأخوذ؟
    if "already exists" in json.dumps(result).lower():
        return "duplicate", None, None, "❌ اسم المستخدم مأخوذ"

    return False, None, None, f"❌ فشل إنشاء الحساب: {result}"

# --- دالة متزامنة غير متزامنة لتنفيذ عملية الإنشاء ---
async def _execute_account_creation_in_background(user_id_str: str, proposed_username: str, password_input: str, bot, chat_id_to_reply: int, message_to_edit: str , user_data):
    import json 

    await activate_global_lock(3)
    
    # 1. تنفيذ العمليات المتزامنة في Thread (الاتصال بـ API)
    success, new_username, new_email, new_password_or_msg = await asyncio.to_thread(
        _run_ishansy_account_creation_sync, proposed_username, password_input
    )
    
    # 2. إذا نجحت العملية 
    if success is True:
        
        # 🟢 استخدام create_local_user الجديدة التي تتعامل مع SQLite مباشرة
        is_new_user = create_local_user(
            user_id=user_id_str,
            username=new_username,
            password=new_password_or_msg # الباسورد المسترجع من الموقع
        )
        
        # ⚠️ ملاحظة: لا نحتاج إلى save_all_changes هنا لأن create_local_user تتولى الحفظ
        
        # 🟢 [الأهم] تفعيل الإحالة المعلقة تلقائياً بعد إنشاء الحساب
        raw_pending = _get_setting('pending_referrals', '{}')
        try:
            pending_referrals = json.loads(raw_pending) if raw_pending else {}
        except:
            pending_referrals = {}
        
        if user_id_str in pending_referrals:
            referrer_id = pending_referrals[user_id_str]
            print(f"🎯 تفعيل إحالة معلقة تلقائياً: {user_id_str} <- {referrer_id}")
            
            if str(referrer_id) != str(user_id_str):  # منع الإحالة الذاتية
                # تسجيل الإحالة بعد إنشاء الحساب
                ref_success = register_referral(user_id_str, referrer_id)
                
                if ref_success:
                    print(f"✅ تم تفعيل الإحالة بنجاح: {user_id_str} <- {referrer_id}")
                    
                    # إرسال إشعار للمُحيل
                    try:
                        await bot.send_message(
                            chat_id=int(referrer_id),
                            text=f"🎉 **تم تفعيل إحالتك!**\n\n"
                                 f"👤 المستخدم الجديد: {new_username}\n"
                                 f"🆔 المعرف: {user_id_str}\n"
                                 f"📅 التاريخ: {datetime.now().strftime('%Y-%m-%d %H:%M')}\n\n"
                                 f"مبروك! سيتم احتساب أرباح الإحالة عند إيداعه."
                        )
                    except Exception as e:
                        print(f"⚠️ لم يتم إرسال إشعار للمُحيل: {e}")
                
                # إزالة من القائمة المعلقة دائماً (نجحت أم فشلت)
                del pending_referrals[user_id_str]
                _set_setting('pending_referrals', json.dumps(pending_referrals))
                print(f"🗑️ تم إزالة الإحالة من pending_referrals: {user_id_str}")
            else:
                # إزالة الإحالة الذاتية
                del pending_referrals[user_id_str]
                _set_setting('pending_referrals', json.dumps(pending_referrals))
                print(f"🗑️ إزالة إحالة ذاتية: {user_id_str}")
        
        # 🟢 إعداد وإرسال رسالة القناة
        admin_msg = (
            f"🆕 <b>تم إنشاء حساب جديد</b>\n\n"
            f"👤 <b>المستخدم:</b> <code>{user_id_str}</code>\n"
            f"💬 <b>اسم المستخدم:</b> <code>{new_username}</code>\n"
            f"🔑 <b>كلمة المرور:</b> <code>{new_password_or_msg}</code>"
        )
        try:
            await bot.send_message(chat_id=OPERATIONS_USERS_ID, text=admin_msg, parse_mode="HTML")
        except Exception as e:
            print(f"⚠️ فشل إرسال إشعار إنشاء الحساب: {e}")

        # 🟢 إرسال رسالة النجاح للمستخدم
        user_msg = (
            f"✅ **تم إنشاء حسابك بنجاح!**\n\n"
            f"▫️ **اسم المستخدم:** `{new_username}`\n"
            f"▫️ **كلمة المرور:** `{new_password_or_msg}`\n\n"
            "يمكنك الآن العودة للقائمة الرئيسية."
        )
    elif success == "duplicate":
        user_msg = "❌ اسم المستخدم مأخوذ بالفعل، الرجاء اختيار اسم آخر."
        success = False
        
    else:
        # ❌ حالة الفشل
        user_msg = new_password_or_msg # رسالة الخطأ
    
    # 3. إرسال الرسالة النهائية للمستخدم
    try:
        reply_markup = InlineKeyboardMarkup([[InlineKeyboardButton("🔙 العودة للقائمة", callback_data="back_to_main")]]) if success else None
        
        await bot.edit_message_text(
            chat_id=chat_id_to_reply,
            message_id=message_to_edit,
            text=user_msg,
            parse_mode="Markdown",
            reply_markup=reply_markup
        )
    except Exception:
        # إذا فشل التعديل، نرسل رسالة جديدة (احتياط)
        reply_markup = InlineKeyboardMarkup([[InlineKeyboardButton("🔙 العودة للقائمة", callback_data="back_to_main")]]) if success else None
        await bot.send_message(
            chat_id=chat_id_to_reply,
            text=user_msg,
            parse_mode="Markdown",
            reply_markup=reply_markup
        )
    finally:
        # ✅ إزالة القفل مهما كانت النتيجة
        user_data.pop('account_creation_lock', None)

async def my_account_handler(update, context):
    query = update.callback_query
    await query.answer()
    user_id_str = str(query.from_user.id)
    now = time.time()

    # 🟢 استدعاء بيانات المستخدم من SQLite مباشرة
    account = get_user_data(user_id_str)

    # ✅ إذا لا يوجد حساب، نبدأ عملية إنشاء الحساب مباشرة
    if not account:
        
        await query.message.reply_text(
            "🛠️ لا يوجد حساب مسجل لك.\n\n"
            "📌 **شروط اسم المستخدم:**\n"
            "1️⃣ لا يحتوي على حروف أو أرقام عربية.\n"
            "2️⃣ لا يحتوي على رموز خاصة مثل: @, #, $, %, &.\n"
            "3️⃣ يمكن أن يحتوي على حروف إنجليزية وأرقام فقط (5 أحرف أو أكثر).\n\n"
            "➡️ الرجاء إدخال اسم مستخدم صالح.",
            parse_mode='Markdown'
        )
        return AWAITING_USERNAME_INPUT

    # 🚫 إذا كان الحساب موجود → عرض الحساب فقط
    username = account.get("username", "unknown")
    password = account.get("password", "غير معروف")
    balance = account.get("balance", 0)
    bonus_balance = account.get("bonus_balance", 0)
    
    # قراءة بيانات العجلة مباشرة من حقول SQLite (يفترض أن database.py عدلت get_user_data لتعيدها)
    # ملاحظة: تم تعديل الشيفرة هنا لتعكس افتراض أن الحقول موجودة كـ INTEGER
    last_day = account.get("daily_wheel_day", 0) 
    spins_today = account.get("daily_wheel_spins_used", 0)

    current_day = int(now // (24 * 3600))
    if last_day != current_day:
        spins_today = 0
    
    # هذه الدالة يجب أن تستخدم الدوال الجديدة لقراءة بيانات الإحالات من جداول SQLite
    max_spins = get_wheel_eligibility(user_id_str) 
    remaining_spins = max(0, max_spins - spins_today)

    wheel_icons = "🎯 " * remaining_spins if remaining_spins > 0 else "0"
    wheel_status = f"🎡 **لفات العجلة المتاحة اليوم:** {wheel_icons} ({remaining_spins} لفة)"
    
    reasons = []
    if remaining_spins == 0:
        if max_spins > 0:
             reasons.append(f"⏳ لقد استنفدت دوراتك لهذا اليوم ({spins_today}/{max_spins}).")
        else:
            # 🟢 استخدام get_net_deposit_last_24h المعدلة
            net_deposit_self = get_net_deposit_last_24h(user_id_str) or 0
            active_referrals = 0
            
            # ⚠️ ملاحظة: يجب تعديل هذا الجزء للبحث في جدول referral_relationships في SQLite
            # بما أننا لا نستطيع الوصول إلى db (القاموس القديم)، نفترض وجود دالة
            # get_active_referrals_count() في database.py
            # For now, we'll simplify this to avoid major database rewrite here:
            
            # ❌ تم حذف الحلقة القديمة التي كانت تعتمد على القاموس db['referral_relationships']
            # ✅ يفترض أن database.py تحتوي على دالة بديلة:
            # active_referrals = get_active_referrals_count(user_id_str) 
            
            remaining_deposit = max(0, 50000 - net_deposit_self)
            remaining_refs = max(0, 5 - active_referrals) # هنا الرقم 5 ثابت، لكن يجب قراءة active_referrals من SQLite

            if remaining_deposit > 0:
                reasons.append(f"💰 تحتاج لإيداع {remaining_deposit:,.0f} ل.س (خلال 24س) لتفعيل لفة")
            if remaining_refs > 0:
                reasons.append(f"👥 تحتاج {remaining_refs} إحالات نشطة (خلال 24س) لتفعيل لفة")
            if remaining_deposit == 0 and remaining_refs == 0 and max_spins == 0:
                 reasons.append("✅ (حققت الشروط، انتظر تحديث البيانات)")

    if reasons:
        wheel_status += "\n🚫 **حالة الأهلية:**\n" + "\n".join(reasons)
    
    text = (
        f"👤 **معلومات حسابك:**\n\n"
        f"🆔 **رقم المستخدم:** `{user_id_str}`\n"
        f"▫️ **اسم المستخدم:** `{username}`\n"
        f"▫️ **كلمة المرور:** `{password}`\n"
        f"💰 **الرصيد الحالي:** {balance:,.0f} ل.س\n"
        f"🎁 **الرصيد من الهدايا:** {bonus_balance:,.0f} ل.س\n\n"
        f"{wheel_status}\n\n"
        f"📌 **شروط اللعبة:** إيداع 50,000 ل.س أو 5 إحالات نشطة (خلال آخر 24س) لتفعيل اللفات اليومية."
    )

    keyboard = [[InlineKeyboardButton("🔙 العودة للقائمة", callback_data="back_to_main")]]
    await query.edit_message_text(text=text, reply_markup=InlineKeyboardMarkup(keyboard), parse_mode="Markdown")
    
    
# --- استقبال اسم المستخدم ---
async def receive_username_input(update, context):
    username_input = update.message.text.strip()
    
    # ... (باقي المنطق كما هو)
    if not re.match(r'^[a-zA-Z0-9]+$', username_input) or len(username_input) < 5:
        await update.message.reply_text(
            "❌ **اسم المستخدم غير صالح.**\n\n"
            "📌 **شروط اسم المستخدم:**\n"
            "1️⃣ 5 أحرف على الأقل.\n"
            "2️⃣ لا يحتوي على حروف أو أرقام عربية.\n"
            "3️⃣ لا يحتوي على رموز خاصة مثل: @, #, $, %, &.\n"
            "4️⃣ يمكن أن يحتوي على حروف إنجليزية وأرقام فقط.\n\n"
            "➡️ الرجاء إدخال اسم مستخدم صالح.",
            parse_mode='Markdown'
        )
        return AWAITING_USERNAME_INPUT

    context.user_data['proposed_username'] = username_input
    await update.message.reply_text(
        "✅ تم قبول اسم المستخدم!\n"
        "الآن أدخل **كلمة المرور** (3 أحرف على الأقل):",
        parse_mode='Markdown'
    )
    return AWAITING_PASSWORD_INPUT


# --- استقبال كلمة المرور (منطق الإنشاء باستخدام API) ---
async def receive_password_input(update: Update, context: ContextTypes.DEFAULT_TYPE):
    password_input = update.message.text.strip()
    user_id_str = str(update.effective_user.id)

    if len(password_input) < 3:
        await update.message.reply_text("❌ كلمة المرور قصيرة جدًا. يجب أن تكون 3 أحرف على الأقل.")
        return AWAITING_PASSWORD_INPUT

    proposed_username = context.user_data.get('proposed_username')
    if not proposed_username:
        await update.message.reply_text("❌ حدث خطأ. الرجاء إعادة المحاولة من البداية.")
        await update.message.reply_text("اضغط /start للبدء من جديد.")
        return ConversationHandler.END

    # ✅ تحقق من القفل قبل أي شيء، القفل يُفعل فقط عند بداية إنشاء الحساب
    if context.user_data.get('account_creation_lock'):
        await update.message.reply_text(
            "⚠️ لا تكبس كثير ياملك! جاري إنشاء حسابك حاليًا.",
            parse_mode="Markdown"
        )
        return ConversationHandler.END

    # ✅ تفعيل القفل لأول مرة هنا
    context.user_data['account_creation_lock'] = True

    # 1. إرسال رسالة فورية للمستخدم (للحصول على message_id)
    await_message = await update.message.reply_text(
        "⏳ جارٍ إنشاء حسابك على موقع إيشانسي... قد يستغرق الأمر بضع ثوانٍ.",
        parse_mode='Markdown'
    )

    # 2. إطلاق المهمة الخلفية
    context.application.create_task(
        _execute_account_creation_in_background(
            user_id_str=user_id_str,
            proposed_username=proposed_username,
            password_input=password_input,
            bot=context.bot,
            chat_id_to_reply=update.effective_chat.id,
            message_to_edit=await_message.message_id,
            user_data=context.user_data 
        )
    )

    # 3. إنهاء المحادثة
    context.user_data.pop('proposed_username', None)
    return ConversationHandler.END