from telegram import InlineKeyboardMarkup, InlineKeyboardButton , Update
from telegram.ext import CallbackQueryHandler , ContextTypes
from database import _get_setting

async def manage_deposits_menu(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    def status(key):
        return "✅" if _get_setting(f"{key}_enabled", True) else "⛔️"

    keyboard = [
        [
            InlineKeyboardButton(
                f"{status('deposit_usdt')} USDT",
                callback_data="toggle_deposit_usdt"
            )
        ],
        [
            InlineKeyboardButton(
                f"{status('deposit_cham_cash')} شام كاش",
                callback_data="toggle_deposit_cham_cash"
            )
        ],
        [
            InlineKeyboardButton(
                f"{status('deposit_syriatel_cash')} سيرياتيل كاش",
                callback_data="toggle_deposit_syriatel_cash"
            )
        ],
        [
            InlineKeyboardButton(
                f"{status('deposit_hawala')} حوالة",
                callback_data="toggle_deposit_hawala"
            )
        ],
        [
            InlineKeyboardButton("⬅️ رجوع", callback_data="admin_panel")
        ]
    ]

    await query.edit_message_text(
        "🔒 <b>إدارة عمليات الإيداع</b>\n\n"
        "اضغط على أي طريقة لتفعيلها أو إيقافها:",
        reply_markup=InlineKeyboardMarkup(keyboard),
        parse_mode='HTML'
    )


async def manage_deposits_menu(update: Update, context: ContextTypes.DEFAULT_TYPE):
    from database import _get_setting

    query = update.callback_query
    await query.answer()

    def status(key):
        return "✅" if _get_setting(f"{key}_enabled", True) else "⛔️"

    keyboard = [
        [InlineKeyboardButton(f"{status('deposit_syriatel_cash')} سيرياتيل كاش", callback_data="toggle_deposit_syriatel_cash")],
        [InlineKeyboardButton("🔙 رجوع للوحة الأدمن", callback_data="admin_panel")],
    ]

    await query.edit_message_text(
        "🔒 **إدارة عمليات الإيداع **\n\n"
        "اضغط على أي طريقة لتفعيلها أو إيقافها:",
        reply_markup=InlineKeyboardMarkup(keyboard),
        parse_mode="Markdown"
    )


async def toggle_deposit_method_callback(update: Update, context: ContextTypes.DEFAULT_TYPE):
    from database import toggle_deposit_method

    query = update.callback_query
    await query.answer()
    data = query.data

    # مثال: toggle_deposit_usdt
    method = data.replace("toggle_", "")
    new_status = toggle_deposit_method(method)

    status_text = "✅ مفعّلة" if new_status else "⛔️ موقوفة"
    await query.answer(f"تم التحديث: {status_text}", show_alert=True)

    # إعادة عرض القائمة
    await manage_deposits_menu(update, context)
