# handlers/admin/users_manage.py
from telegram import InlineKeyboardButton, InlineKeyboardMarkup, Update
from telegram.ext import ContextTypes, ConversationHandler, CallbackQueryHandler, MessageHandler, filters
from datetime import datetime
import time
import asyncio
# مراحل الـ Conversation
SELECT_USER, ADD_BALANCE, REMOVE_BALANCE, SEND_MESSAGE , SEARCH_USER = range(5)
USERS_PER_PAGE = 10
from database import get_connection , get_active_referrals
import json
# --- عرض قائمة المستخدمين مع صفحات ---
# --- عرض قائمة المستخدمين مع صفحات ---

async def show_users(update: Update, context: ContextTypes.DEFAULT_TYPE, page: int = 0):
    query = update.callback_query
    await query.answer()

    # جلب قائمة المستخدمين من قاعدة البيانات
    with get_connection() as conn:
        cur = conn.cursor()
        cur.execute("SELECT user_id, username FROM user_accounts ORDER BY user_id ASC")
        rows = cur.fetchall()
    
    user_ids = [row['user_id'] for row in rows]
    total_pages = (len(user_ids) - 1) // USERS_PER_PAGE + 1

    start = page * USERS_PER_PAGE
    end = start + USERS_PER_PAGE
    current_users = rows[start:end]

    keyboard = []

    # زر البحث في البداية
    keyboard.append([InlineKeyboardButton("🔍 البحث عن مستخدم", callback_data="search_user_prompt")])

    for row in current_users:
        uid = row['user_id']
        username = row['username'] or f"User {uid}"
        # التحقق من حالة الحظر
        with get_connection() as conn:
            cur = conn.cursor()
            cur.execute("SELECT 1 FROM banned_users WHERE user_id = ?", (uid,))
            banned = cur.fetchone() is not None
        ban_status = " ⛔ محظور" if banned else ""

        # حساب عدد الإحالات
        with get_connection() as conn:
            cur = conn.cursor()
            cur.execute("SELECT COUNT(*) as cnt FROM referral_relationships WHERE referrer_id = ?", (uid,))
            referral_count = cur.fetchone()["cnt"]

        keyboard.append([
            InlineKeyboardButton(f"{username}{ban_status} (الإحالات: {referral_count})", callback_data=f"user_info:{uid}")
        ])

    # أزرار التنقل
    nav_buttons = []
    if page > 0:
        nav_buttons.append(InlineKeyboardButton("⬅️ السابق", callback_data=f"users_page:{page-1}"))
    if page < total_pages - 1:
        nav_buttons.append(InlineKeyboardButton("التالي ➡️", callback_data=f"users_page:{page+1}"))
    if nav_buttons:
        keyboard.append(nav_buttons)

    keyboard.append([InlineKeyboardButton("🔙 العودة للوحة الأدمن", callback_data="back_to_admin")])
    reply_markup = InlineKeyboardMarkup(keyboard)
    await query.edit_message_text(f"👥 قائمة المستخدمين (صفحة {page+1}/{total_pages}):", reply_markup=reply_markup)
# --- عرض بيانات المستخدم وأزرار الوظائف ---
async def show_user_info(update: Update, context: ContextTypes.DEFAULT_TYPE, user_id: str):
    query = update.callback_query
    await query.answer()

    # جلب بيانات المستخدم من SQLite
    with get_connection() as conn:
        cur = conn.cursor()
        
        # 1. بيانات المستخدم الأساسية
        cur.execute("SELECT * FROM user_accounts WHERE user_id = ?", (user_id,))
        row = cur.fetchone()
        if not row:
            await query.edit_message_text("❌ المستخدم غير موجود.")
            return ConversationHandler.END
        
        user = dict(row)
        user['has_withdrawn'] = bool(user['has_withdrawn'])
        if user.get('user_history'):
            try:
                user['user_history'] = json.loads(user['user_history'])
            except:
                user['user_history'] = []
        
        # 2. جلب الأرباح المعلقة من جدول referral_earnings
        cur.execute("""
            SELECT COUNT(*) as count, SUM(amount) as total 
            FROM referral_earnings 
            WHERE referrer_id = ? AND status = 'pending'
        """, (user_id,))
        pending_result = cur.fetchone()
        
        pending_count = pending_result['count'] or 0
        pending_total = pending_result['total'] or 0.0
        
        # 3. جلب الأرباح المتاحة (التي حان موعدها)
        import datetime
        cutoff_date = (datetime.datetime.now() - datetime.timedelta(days=10)).isoformat()
        cur.execute("""
            SELECT COUNT(*) as count, SUM(amount) as total 
            FROM referral_earnings 
            WHERE referrer_id = ? AND status = 'pending' AND created_at <= ?
        """, (user_id, cutoff_date))
        ready_result = cur.fetchone()
        
        ready_count = ready_result['count'] or 0
        ready_total = ready_result['total'] or 0.0
        
        # 4. جلب الأرباح الموزعة
        cur.execute("""
            SELECT COUNT(*) as count, SUM(amount) as total 
            FROM referral_earnings 
            WHERE referrer_id = ? AND status IN ('available', 'distributed')
        """, (user_id,))
        distributed_result = cur.fetchone()
        
        distributed_count = distributed_result['count'] or 0
        distributed_total = distributed_result['total'] or 0.0
        
        # 5. حساب عدد الإحالات
        cur.execute("SELECT COUNT(*) AS cnt FROM referral_relationships WHERE referrer_id = ?", (user_id,))
        referral_count = cur.fetchone()['cnt'] or 0
        
        # 6. التحقق من الحظر
        cur.execute("SELECT value FROM app_settings WHERE key = 'banned_users'")
        setting_row = cur.fetchone()
        banned_list = []
        if setting_row and setting_row['value']:
            banned_list = json.loads(setting_row['value'])
        is_banned = str(user_id) in banned_list

    context.user_data['target_user'] = user_id

    active_referrals = get_active_referrals(user_id)
    active_count = len(active_referrals)


    # بناء النص مع جميع المعلومات
    text = (
        f"👤 **معلومات المستخدم**\n\n"
        f"🆔 **معرف التيليجرام:** `{user_id}`\n"
        f"▫️ **اسم المستخدم:** `{user.get('username', 'بدون')}`\n"
        f"▫️ **كلمة المرور:** `{user.get('password', 'بدون')}`\n"
        f"💰 **الرصيد الحالي:** {user.get('balance', 0.0):,.2f} ل.س\n"
        f"🎁 **رصيد الهدايا:** {user.get('bonus_balance', 0.0):,.2f} ل.س\n\n"
        
        f"📊 **إحصائيات الإحالة:**\n"
        f"   👥 **عدد الإحالات:** {referral_count}\n"
        f"\n\n🔥 **الإحالات النشطة:** {active_count}\n"
        f"   ⏳ **الأرباح المعلقة:** {pending_count} = {pending_total:,.2f} ل.س\n"
        f"   ✅ **الأرباح جاهزة (10+ يوم):** {ready_count} = {ready_total:,.2f} ل.س\n"
        f"   💰 **الأرباح الموزعة:** {distributed_count} = {distributed_total:,.2f} ل.س\n\n"
        
        f"📈 **إحصائيات الحساب:**\n"
        f"   💵 **مجموع الإيداعات:** {user.get('total_deposited', 0.0):,.2f} ل.س\n"
        f"   🔄 **عدد عمليات السحب:** {user.get('has_withdrawn', '❌')}\n\n"
        
        f"🔒 **حالة الحظر:** {'⛔ محظور' if is_banned else '✅ غير محظور'}\n"
        f"📅 **تاريخ التسجيل:** {datetime.datetime.now().strftime('%Y-%m-%d %H:%M')}"
    )
    
    # إذا كان هناك أرباح معلقة، أضف تفاصيل إضافية
    if pending_count > 0:
        text += f"\n\n📋 **تفاصيل الأرباح المعلقة:**"
        
        with get_connection() as conn:
            cur = conn.cursor()
            cur.execute("""
                SELECT id, invited_id, amount, created_at 
                FROM referral_earnings 
                WHERE referrer_id = ? AND status = 'pending'
                ORDER BY created_at ASC
                LIMIT 5
            """, (user_id,))
            
            pending_details = cur.fetchall()
            for i, pd in enumerate(pending_details, 1):
                created = datetime.datetime.fromisoformat(pd['created_at'])
                days_old = (datetime.datetime.now() - created).days
                text += f"\n   {i}. من {pd['invited_id']}: {pd['amount']:.2f} ل.س ({days_old} يوم)"

    ban_button = InlineKeyboardButton("⛔ فك الحظر", callback_data="unban_user") if is_banned else InlineKeyboardButton("⛔ حظر المستخدم", callback_data="ban_user")
    keyboard = [
        
        [InlineKeyboardButton("➕ إضافة رصيد", callback_data="add_balance")],
        [InlineKeyboardButton("➖ سحب رصيد", callback_data="remove_balance")],
        [InlineKeyboardButton("📜 سجل المستخدم", callback_data="user_history")],
        [ban_button],
        [InlineKeyboardButton("✉️ إرسال رسالة خاصة", callback_data="message_user")],
        [InlineKeyboardButton("🔙 العودة لقائمة المستخدمين", callback_data="users_page:0")]
    ]

    reply_markup = InlineKeyboardMarkup(keyboard)
    await query.edit_message_text(text, reply_markup=reply_markup , parse_mode="Markdown")
    return SELECT_USER
# --- callback لجميع أزرار إدارة المستخدم ---
async def show_user_pending_earnings(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """عرض تفاصيل الأرباح المعلقة للمستخدم"""
    query = update.callback_query
    await query.answer()
    
    user_id = context.user_data.get('target_user')
    if not user_id:
        await query.edit_message_text("❌ لم يتم تحديد المستخدم.")
        return
    
    try:
        import datetime
        
        with get_connection() as conn:
            cur = conn.cursor()
            
            # 1. إحصائيات عامة
            cur.execute("""
                SELECT 
                    COUNT(*) as total_count,
                    SUM(amount) as total_amount,
                    MIN(created_at) as oldest,
                    MAX(created_at) as newest
                FROM referral_earnings 
                WHERE referrer_id = ? AND status = 'pending'
            """, (user_id,))
            
            stats = cur.fetchone()
            
            # 2. تفاصيل الأرباح المعلقة
            cur.execute("""
                SELECT id, invited_id, amount, created_at, status
                FROM referral_earnings 
                WHERE referrer_id = ? AND status = 'pending'
                ORDER BY created_at ASC
            """, (user_id,))
            
            earnings = cur.fetchall()
            
            if not earnings:
                text = f"📭 **المستخدم {user_id} ليس لديه أرباح معلقة.**"
            else:
                text = f"📊 **تفاصيل الأرباح المعلقة للمستخدم:**\n"
                text += f"🆔 **المستخدم:** {user_id}\n"
                text += f"📈 **الإجمالي:** {stats['total_count']} ربح = {stats['total_amount'] or 0:.2f} ل.س\n\n"
                
                if stats['oldest']:
                    oldest = datetime.datetime.fromisoformat(stats['oldest'])
                    days_oldest = (datetime.datetime.now() - oldest).days
                    text += f"📅 **أقدم ربح:** {days_oldest} يوم ({stats['oldest'][:10]})\n"
                
                if stats['newest']:
                    newest = datetime.datetime.fromisoformat(stats['newest'])
                    days_newest = (datetime.datetime.now() - newest).days
                    text += f"📅 **أحدث ربح:** {days_newest} يوم ({stats['newest'][:10]})\n\n"
                
                text += "📋 **قائمة الأرباح المعلقة:**\n\n"
                
                now = datetime.datetime.now()
                for i, earn in enumerate(earnings, 1):
                    try:
                        created = datetime.datetime.fromisoformat(earn['created_at'])
                        days_old = (now - created).days
                        
                        text += f"**{i}. رقم: {earn['id']}**\n"
                        text += f"   👤 **المدعو:** {earn['invited_id']}\n"
                        text += f"   💰 **المبلغ:** {earn['amount']:.2f} ل.س\n"
                        text += f"   📅 **العمر:** {days_old} يوم\n"
                        text += f"   ⏰ **التاريخ:** {created.strftime('%Y-%m-%d %H:%M')}\n"
                        
                        # تحقق إذا كان الربح مؤهلاً للتوزيع (10+ يوم)
                        if days_old >= 10:
                            text += f"   ✅ **مؤهل للتوزيع** (مضى {days_old} يوم)\n"
                        else:
                            remaining = 10 - days_old
                            text += f"   ⏳ **ينتظر {remaining} يوم**\n"
                        
                        text += "\n"
                        
                    except Exception as e:
                        text += f"**{i}. ⚠️ خطأ في السجل:** {str(e)}\n\n"
                
                # 3. حساب الأرباح المؤهلة للتوزيع
                cutoff_date = (now - datetime.timedelta(days=10)).isoformat()
                cur.execute("""
                    SELECT COUNT(*) as eligible_count, SUM(amount) as eligible_total
                    FROM referral_earnings 
                    WHERE referrer_id = ? AND status = 'pending' AND created_at <= ?
                """, (user_id, cutoff_date))
                
                eligible = cur.fetchone()
                text += f"🎯 **الأرباح المؤهلة للتوزيع (10+ يوم):**\n"
                text += f"   • العدد: {eligible['eligible_count'] or 0}\n"
                text += f"   • المجموع: {eligible['eligible_total'] or 0:.2f} ل.س\n"
        
        keyboard = [
            [InlineKeyboardButton("🔙 رجوع لمعلومات المستخدم", callback_data=f"user_info:{user_id}")],
            [InlineKeyboardButton("💰 توزيع الأرباح لهذا المستخدم", callback_data=f"distribute_user_earnings:{user_id}")]
        ]
        reply_markup = InlineKeyboardMarkup(keyboard)
        
        await query.edit_message_text(
            text,
            reply_markup=reply_markup,
            parse_mode="Markdown"
        )
        
    except Exception as e:
        print(f"❌ خطأ في show_user_pending_earnings: {e}")
        await query.edit_message_text(
            f"❌ **حدث خطأ في عرض تفاصيل الأرباح**\n\n"
            f"الخطأ: {str(e)}",
            parse_mode="Markdown"
        )

def normalize_ts(ts):
    if isinstance(ts, (int, float)):
        return int(ts)
    try:
        return int(datetime.fromisoformat(ts.replace(" ", "T")).timestamp())
    except:
        return 0
async def users_callback_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    data = query.data

    # === التنقل بين الصفحات أو عرض المستخدم ===
    if data.startswith("users_page:"):
        page = int(data.split(":")[1])
        await show_users(update, context, page)
        return  # لا حاجة لحالة — هذا عرض فقط

    elif data.startswith("user_info:"):
        user_id = data.split(":")[1]
        context.user_data['target_user'] = user_id  # حفظ المستخدم المستهدف
        await show_user_info(update, context, user_id)
        return

    # === العمليات التي تتطلب إدخالًا (ابدأ محادثة) ===
    elif data == "add_balance":
        await query.message.reply_text("💰 أدخل المبلغ لإضافته:")
        return ADD_BALANCE

    elif data == "remove_balance":
        await query.message.reply_text("💸 أدخل المبلغ لسحبه:")
        return REMOVE_BALANCE

    elif data == "search_user_prompt":
        await query.message.reply_text(
            "🔍 **أدخل معرف التيليجرام (ID) أو اسم المستخدم (Username) للبحث:**", 
            parse_mode="Markdown"
        )
        return SEARCH_USER

    elif data == "message_user":
        await query.message.reply_text("✉️ أرسل الرسالة الخاصة لهذا المستخدم:")
        return SEND_MESSAGE

    # === عرض السجل (لا يتطلب إدخالًا) ===
    elif data == "user_history":
        user_id = context.user_data.get('target_user')
        if not user_id:
            await query.message.reply_text("❌ لم يتم تحديد المستخدم.")
            return  # لا حالة

        # جلب السجلات (كما في الكود الأصلي)
        combined_logs = []
        with get_connection() as conn:
            cur = conn.cursor()
            # من user_history
            cur.execute("SELECT user_history FROM user_accounts WHERE user_id = ?", (user_id,))
            row = cur.fetchone()
            if row and row["user_history"]:
                history = json.loads(row["user_history"])
                for h in history:
                    combined_logs.append({
                        "timestamp": h.get("timestamp", ""),
                        "type": h.get("type", ""),
                        "amount": h.get("amount", 0),
                        "method": h.get("method", "")
                    })
            # من transaction_logs
            cur.execute("SELECT type, amount, method, timestamp FROM transaction_logs WHERE user_id = ?", (user_id,))
            for tx in cur.fetchall():
                combined_logs.append({
                    "timestamp": datetime.fromtimestamp(tx["timestamp"]).strftime("%Y-%m-%d %H:%M:%S"),
                    "type": tx["type"],
                    "amount": tx["amount"],
                    "method": tx["method"]
                })

        combined_logs.sort(
            key=lambda x: normalize_ts(x["timestamp"]),
            reverse=True
        )

        text = "\n".join([f"{log['timestamp']}: {log['type']} {log['amount']} عبر {log['method']}" for log in combined_logs]) if combined_logs else "📄 لا يوجد سجل."

        await query.message.reply_text(text)
        return

    # === حظر المستخدم ===
    elif data == "ban_user":
        user_id = context.user_data.get('target_user')
        if not user_id:
            await query.message.reply_text("❌ لم يتم تحديد المستخدم.")
            return

        # استخدام app_settings لتخزين المحظورين (كما في الكود الأصلي)
        with get_connection() as conn:
            cur = conn.cursor()
            cur.execute("SELECT value FROM app_settings WHERE key = 'banned_users'")
            row = cur.fetchone()
            banned_users = json.loads(row["value"]) if row and row["value"] else []

            if user_id in banned_users:
                msg = f"⚠️ المستخدم **{user_id}** محظور مسبقاً."
            else:
                banned_users.append(user_id)
                cur.execute("INSERT OR REPLACE INTO app_settings (key, value) VALUES (?, ?)", 
                           ("banned_users", json.dumps(banned_users)))
                msg = f"⛔ تم حظر المستخدم **{user_id}** بنجاح."

        await query.message.reply_text(msg, parse_mode="Markdown")
        return
    elif data == "unban_user":
        user_id = context.user_data.get('target_user')
        if not user_id:
            await query.edit_message_text("❌ لم يتم تحديد المستخدم.")
            return

        with get_connection() as conn:
            cur = conn.cursor()
            
            # 1. جلب قائمة المحظورين الحالية
            cur.execute("SELECT value FROM app_settings WHERE key = 'banned_users'")
            setting_row = cur.fetchone()
            
            if not setting_row or not setting_row['value']:
                msg = f"⚠️ المستخدم **{user_id}** غير محظور."
            else:
                banned_users = json.loads(setting_row['value'])
                
                # 2. التحقق إذا كان المستخدم موجوداً في القائمة
                if user_id not in banned_users:
                    msg = f"⚠️ المستخدم **{user_id}** غير محظور."
                else:
                    # 3. إزالة المستخدم من قائمة المحظورين
                    banned_users.remove(user_id)
                    cur.execute("INSERT OR REPLACE INTO app_settings (key, value) VALUES (?, ?)", 
                               ("banned_users", json.dumps(banned_users)))
                    conn.commit()
                    
                    msg = f"✅ تم فك حظر المستخدم **{user_id}** بنجاح."
                    
                    # 4. إرسال إشعار للمستخدم (اختياري)
                    try:
                        await context.bot.send_message(
                            chat_id=int(user_id),
                            text=f"✅ **تم فك حظر حسابك**\n\n"
                                 f"🎉 تم إعادة تفعيل حسابك من قبل الإدارة.\n"
                                 f"📅 **التاريخ:** {datetime.now().strftime('%Y-%m-%d %H:%M:%S')}\n\n"
                                 f"🚀 يمكنك الآن استخدام البوت بشكل طبيعي."
                        )
                    except Exception as e:
                        print(f"⚠️ فشل إرسال رسالة فك الحظر للمستخدم: {e}")
        
        await query.edit_message_text(msg, parse_mode="Markdown")
        
        # 5. تحديث صفحة المستخدم بعد ثانيتين
        await asyncio.sleep(2)
        await show_user_info(update, context, user_id)
        return

    # === العودة للوحة الأدمن ===
    elif data == "back_to_admin":
        from handlers.admin.admin_menu import admin_panel_handler
        await admin_panel_handler(update, context)
        return ConversationHandler.END

    # === افتراضي ===
    return ConversationHandler.END

# --- إضافة الرصيد ---
# --- إضافة الرصيد ---
async def add_balance_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    message = update.message
    user_id = context.user_data.get('target_user')
    
    if not user_id:
        await message.reply_text("❌ لم يتم تحديد مستخدم.")
        return ConversationHandler.END
    
    try:
        amount = float(message.text.strip())
        if amount <= 0:
            await message.reply_text("❌ المبلغ يجب أن يكون أكبر من صفر.")
            return ConversationHandler.END
    except ValueError:
        await message.reply_text("❌ الرجاء إدخال رقم صحيح.")
        return ConversationHandler.END
    
    # جلب اسم المستخدم قبل التحديث
    with get_connection() as conn:
        cur = conn.cursor()
        
        # جلب اسم المستخدم
        cur.execute("SELECT username FROM user_accounts WHERE user_id = ?", (user_id,))
        user_row = cur.fetchone()
        username = user_row['username'] if user_row and user_row['username'] else user_id
        
        # إضافة الرصيد
        cur.execute("UPDATE user_accounts SET balance = balance + ? WHERE user_id = ?", 
                   (amount, user_id))
        conn.commit()
    
    # إرسال رسالة للمستخدم
    try:
        await context.bot.send_message(
            chat_id=int(user_id),
            text=f"🎉 **تم إضافة رصيد إلى حسابك**\n\n"
                 f"💰 **المبلغ:** {amount:,.2f}\n"
                 f"👨‍💼 **بواسطة:** الإدارة\n"
                 f"📅 **التاريخ:** {datetime.now().strftime('%Y-%m-%d %H:%M:%S')}\n\n"
                 f"✅ تمت العملية بنجاح."
        )
    except Exception as e:
        print(f"❌ فشل إرسال رسالة للمستخدم {user_id}: {e}")
    
    # إرسال رسالة تأكيد للأدمن
    await message.reply_text(
        f"✅ تم إضافة **{amount:,.2f}** إلى رصيد المستخدم:\n"
        f"👤 **المستخدم:** {username}\n"
        f"🆔 **ID:** {user_id}\n\n"
        f"📨 تم إرسال إشعار للمستخدم.", 
        parse_mode="Markdown"
    )
    
    # تسجيل العملية في سجل المستخدم
    with get_connection() as conn:
        cur = conn.cursor()
        
        # جلب السجل الحالي
        cur.execute("SELECT user_history FROM user_accounts WHERE user_id = ?", (user_id,))
        row = cur.fetchone()
        
        if row and row["user_history"]:
            history = json.loads(row["user_history"])
        else:
            history = []
        
        # إضافة العملية الجديدة
        history.append({
            "timestamp": datetime.now().isoformat(),
            "type": "إضافة رصيد من الإدارة",
            "amount": amount,
            "method": "إداري",
            "admin": update.effective_user.id
        })
        
        # تحديث السجل
        cur.execute("UPDATE user_accounts SET user_history = ? WHERE user_id = ?",
                   (json.dumps(history), user_id))
        conn.commit()
    
    return ConversationHandler.END


async def remove_balance_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    message = update.message
    user_id = context.user_data.get('target_user')
    
    if not user_id:
        await message.reply_text("❌ لم يتم تحديد مستخدم.")
        return ConversationHandler.END
    
    try:
        amount = float(message.text.strip())
        if amount <= 0:
            await message.reply_text("❌ المبلغ يجب أن يكون أكبر من صفر.")
            return ConversationHandler.END
    except ValueError:
        await message.reply_text("❌ الرجاء إدخال رقم صحيح.")
        return ConversationHandler.END
    
    # التحقق من أن الرصيد كافي
    with get_connection() as conn:
        cur = conn.cursor()
        
        # جلب الرصيد الحالي واسم المستخدم
        cur.execute("SELECT balance, username FROM user_accounts WHERE user_id = ?", (user_id,))
        user_row = cur.fetchone()
        
        if not user_row:
            await message.reply_text("❌ المستخدم غير موجود.")
            return ConversationHandler.END
        
        current_balance = user_row['balance']
        username = user_row['username'] if user_row['username'] else user_id
        
        if current_balance < amount:
            await message.reply_text(
                f"❌ الرصيد غير كافي!\n"
                f"💰 **الرصيد الحالي:** {current_balance:,.2f}\n"
                f"💸 **المبلغ المطلوب:** {amount:,.2f}"
            )
            return ConversationHandler.END
        
        # سحب الرصيد
        cur.execute("UPDATE user_accounts SET balance = balance - ? WHERE user_id = ?", 
                   (amount, user_id))
        conn.commit()
    
    # إرسال رسالة للمستخدم
    try:
        await context.bot.send_message(
            chat_id=int(user_id),
            text=f"⚠️ **تم سحب رصيد من حسابك**\n\n"
                 f"💰 **المبلغ:** {amount:,.2f}\n"
                 f"👨‍💼 **بواسطة:** الإدارة\n"
                 f"📅 **التاريخ:** {datetime.now().strftime('%Y-%m-%d %H:%M:%S')}\n\n"
                 f"📞 للاستفسار يرجى التواصل مع الدعم."
        )
    except Exception as e:
        print(f"❌ فشل إرسال رسالة للمستخدم {user_id}: {e}")
    
    # إرسال رسالة تأكيد للأدمن
    await message.reply_text(
        f"✅ تم سحب **{amount:,.2f}** من رصيد المستخدم:\n"
        f"👤 **المستخدم:** {username}\n"
        f"🆔 **ID:** {user_id}\n"
        f"💰 **الرصيد الجديد:** {current_balance - amount:,.2f}\n\n"
        f"📨 تم إرسال إشعار للمستخدم.", 
        parse_mode="Markdown"
    )
    
    # تسجيل العملية في سجل المستخدم
    with get_connection() as conn:
        cur = conn.cursor()
        
        # جلب السجل الحالي
        cur.execute("SELECT user_history FROM user_accounts WHERE user_id = ?", (user_id,))
        row = cur.fetchone()
        
        if row and row["user_history"]:
            history = json.loads(row["user_history"])
        else:
            history = []
        
        # إضافة العملية الجديدة
        history.append({
            "timestamp": datetime.now().isoformat(),
            "type": "سحب رصيد من الإدارة",
            "amount": amount,
            "method": "إداري",
            "admin": update.effective_user.id
        })
        
        # تحديث السجل
        cur.execute("UPDATE user_accounts SET user_history = ? WHERE user_id = ?",
                   (json.dumps(history), user_id))
        conn.commit()
    
    return ConversationHandler.END
# --- إرسال رسالة خاصة ---
async def send_message_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    text = update.message.text
    user_id = context.user_data.get('target_user')
    
    if not user_id:
        await update.message.reply_text("❌ لم يتم تحديد المستخدم المستهدف.")
        return SELECT_USER

    from database import get_user_data

    # التحقق من وجود المستخدم
    user_data = get_user_data(user_id)
    if not user_data:
        await update.message.reply_text("❌ المستخدم غير موجود في قاعدة البيانات.")
        return SELECT_USER

    try:
        await context.bot.send_message(
            chat_id=int(user_id),
            text=f"✉️ رسالة من الأدمن:\n\n{text}"
        )
        await update.message.reply_text("✅ تم إرسال الرسالة بنجاح.")
    except Exception as e:
        await update.message.reply_text(f"❌ حدث خطأ أثناء الإرسال: {e}")

    return SELECT_USER


from telegram import Update as TgUpdate

# --- معالجة إدخال البحث عن مستخدم ---
# --- معالجة إدخال البحث عن مستخدم ---
async def search_user_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    from database import get_user_data

    search_term = update.message.text.strip()
    user_id_found = None

    # 1️⃣ البحث حسب معرف المستخدم مباشرة
    user_data = get_user_data(search_term)
    if user_data:
        user_id_found = search_term
    else:
        # 2️⃣ البحث حسب اسم المستخدم
        search_term_lower = search_term.lower().replace("@", "")
        # للحصول على جميع المستخدمين، يجب الوصول إلى جميع user_ids
        from database import get_connection

        with get_connection() as conn:
            cur = conn.cursor()
            cur.execute("SELECT user_id, username FROM user_accounts")
            for row in cur.fetchall():
                username_lower = (row["username"] or "").lower().replace("@", "")
                if username_lower == search_term_lower or search_term_lower in username_lower:
                    user_id_found = row["user_id"]
                    break

    if user_id_found:
        # استدعاء show_user_info مباشرة
        class SimpleQuery:
            def __init__(self, message):
                self.message = message
            async def answer(self): pass
            async def edit_message_text(self, *args, **kwargs):
                await self.message.reply_text(*args, **kwargs)

        fake_query = SimpleQuery(update.message)
        
        fake_update = TgUpdate(update.update_id, callback_query=fake_query)

        
        await show_user_info(fake_update, context, user_id_found)
        return SELECT_USER
    else:
        await update.message.reply_text("❌ لم يتم العثور على مستخدم بالمعرّف أو اسم المستخدم المدخل.")
        return SELECT_USER




# --- إلغاء العملية ---
async def cancel_action(update, context):
    await update.message.reply_text("❌ تم إلغاء العملية.")
    return ConversationHandler.END
