import json
from telegram import InlineKeyboardButton, InlineKeyboardMarkup, Update
from telegram.ext import (
    ContextTypes,
    ConversationHandler,
)

CONFIG_FILE = r"C:\Users\Administrator\Desktop\ichancybots\luffy\luffyn\chaluf\luffyupdate\luffyupdate\data\config.json"

# الحالات
(
    AWAITING_MAX_DIRECT_WITHDRAW,
    AWAITING_MIN_DEPOSIT,
    AWAITING_MIN_WITHDRAW,
    AWAITING_BONUS_GIFT,
    AWAITING_MIN_USDT,
    AWAITING_WITHDRAW_FEE,
) = range(6)


# 🔹 تحميل الإعدادات من JSON
def load_config():
    try:
        with open(CONFIG_FILE, "r", encoding="utf-8") as f:
            return json.load(f)
    except Exception:
        return {}


# 🔹 حفظ الإعدادات إلى JSON
def save_config(config):
    with open(CONFIG_FILE, "w", encoding="utf-8") as f:
        json.dump(config, f, ensure_ascii=False, indent=4)


# --- عرض قائمة إدارة النسب والإعدادات ---
async def manage_rates_menu(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    config = load_config()

    text = (
        "⚙️ الإعدادات الحالية:\n\n"
        f"💰 الحد الأقصى للسحب المباشر:\n{format_payment_methods(config, 'MAX_DIRECT_WITHDRAW')}\n\n"
        f"💵 الحد الأدنى للإيداع:\n{format_payment_methods(config, 'MINIMUM_DEPOSIT')}\n\n"
        f"🏧 الحد الأدنى للسحب:\n{format_payment_methods(config, 'MINIMUM_WITHDRAWAL')}\n\n"
        f"💸 نسبة خصم السحب:\n{format_payment_methods(config, 'WITHDRAWAL_FEE_PERCENT')}\n\n"
        f"🎁 نسبة البونص:\n{format_payment_methods(config, 'Bouns_Gift')}\n"
    )

    keyboard = [
        [InlineKeyboardButton("💰 تعديل الحد الأقصى للسحب", callback_data="edit_max_withdraw")],
        [InlineKeyboardButton("💵 تعديل الحد الأدنى للإيداع", callback_data="edit_min_deposit")],
        [InlineKeyboardButton("🏧 تعديل الحد الأدنى للسحب", callback_data="edit_min_withdraw")],
        [InlineKeyboardButton("💸 تعديل نسبة خصم السحب", callback_data="edit_withdraw_fee")],
        [InlineKeyboardButton("🎁 تعديل نسبة البونص", callback_data="edit_bonus_gift")],
        [InlineKeyboardButton("💲 تعديل حد USDT الأدنى", callback_data="edit_min_usdt")],
        [InlineKeyboardButton("🔙 العودة للوحة الأدمن", callback_data="admin_panel")],
    ]

    await query.edit_message_text(text, reply_markup=InlineKeyboardMarkup(keyboard))


# --- اختيار وسيلة الدفع ---
async def choose_method(update: Update, context: ContextTypes.DEFAULT_TYPE, key_name, prompt_text, next_state):
    query = update.callback_query
    await query.answer()
    context.user_data["edit_key"] = key_name
    context.user_data["next_state"] = next_state
    context.user_data["prompt_text"] = prompt_text

    keyboard = [
        [InlineKeyboardButton("📱 سيريتيل كاش", callback_data=f"edit_method:SYRIATEL")],
        [InlineKeyboardButton("💳 شام كاش", callback_data=f"edit_method:SHAM")],
        [InlineKeyboardButton("💲 USDT", callback_data=f"edit_method:USDT")],
        [InlineKeyboardButton("🏦 حوالة", callback_data=f"edit_method:HAWALA")],
        [InlineKeyboardButton("🔙 العودة", callback_data="manage_rates_menu")]
    ]

    await query.edit_message_text("اختر وسيلة الدفع التي تريد تعديل إعدادها 👇", reply_markup=InlineKeyboardMarkup(keyboard))
    return next_state


# --- استقبال الوسيلة المختارة ---
async def select_method(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    method = query.data.split(":")[1]
    context.user_data["edit_method"] = method
    await query.edit_message_text(f"{context.user_data['prompt_text']} ({method})")
    return context.user_data["next_state"]


# --- استقبال القيمة الجديدة وتحديثها ---
async def receive_new_value(update: Update, context: ContextTypes.DEFAULT_TYPE):
    key = context.user_data.get("edit_key")
    method = context.user_data.get("edit_method")
    value = update.message.text.strip()

    config = load_config()
    try:
        if key not in config or not isinstance(config[key], dict):
            config[key] = {}

        config[key][method] = float(value) if "." in value else int(value)
        save_config(config)

        await update.message.reply_text(f"✅ تم تحديث {key} ({method}) إلى {value} بنجاح.")
    except Exception as e:
        await update.message.reply_text(f"❌ خطأ أثناء الحفظ: {e}")

    return ConversationHandler.END


# --- دوال بدء التعديلات ---
async def start_edit_max_withdraw(update, context):
    return await choose_method(update, context, "MAX_DIRECT_WITHDRAW", "💰 أرسل الحد الأقصى الجديد للسحب:", AWAITING_MAX_DIRECT_WITHDRAW)

async def start_edit_min_deposit(update, context):
    return await choose_method(update, context, "MINIMUM_DEPOSIT", "💵 أرسل الحد الأدنى الجديد للإيداع:", AWAITING_MIN_DEPOSIT)

async def start_edit_min_withdraw(update, context):
    return await choose_method(update, context, "MINIMUM_WITHDRAWAL", "🏧 أرسل الحد الأدنى الجديد للسحب:", AWAITING_MIN_WITHDRAW)

async def start_edit_bonus_gift(update, context):
    return await choose_method(update, context, "Bouns_Gift", "🎁 أرسل نسبة البونص الجديدة (مثلاً 10):", AWAITING_BONUS_GIFT)

async def start_edit_min_usdt(update, context):
    return await choose_method(update, context, "MINIMUM_USDT", "💲 أرسل الحد الأدنى الجديد لسحب USDT:", AWAITING_MIN_USDT)

async def start_edit_withdraw_fee(update, context):
    return await choose_method(update, context, "WITHDRAWAL_FEE_PERCENT", "💸 أرسل نسبة خصم السحب الجديدة (مثلاً 5 تعني 5%):", AWAITING_WITHDRAW_FEE)


# --- تنسيق عرض القيم ---
def format_payment_methods(config, key):
    values = config.get(key, {})
    if not isinstance(values, dict):
        return str(values)

    return (
        f"• سيريتيل كاش: {values.get('SYRIATEL', 0)}\n"
        f"• شام كاش: {values.get('SHAM', 0)}\n"
        f"• USDT: {values.get('USDT', 0)}\n"
        f"• حوالة: {values.get('HAWALA', 0)}"
    )
