import time
from telegram import Update
from telegram.ext import ContextTypes
from config import OPERATIONS_CHANNEL_ID, ADMIN_IDS , get_config


async def admin_approve_hawala_deposit(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    # تحقق أن الذي ضغط هو الأدمن فقط
    if str(query.from_user.id) not in map(str, ADMIN_IDS):
        await query.answer("🚫 فقط الأدمن يمكنه تنفيذ هذا الإجراء.", show_alert=True)
        return


    try:
        user_id = query.data.split(":")[1]
        user_id_str = str(user_id)
        user_accounts = db.setdefault("user_accounts", {})

        # إذا ما كان الحساب موجود، أنشئه
        account = user_accounts.setdefault(user_id_str, {"balance": 0.0, "total_deposited": 0.0})

        # استخراج المبلغ من الرسالة
        text = query.message.caption or query.message.text or ""
        import re
        amount_match = re.search(r"💰 المبلغ:\s*([\d,\.]+)", text)
        if not amount_match:
            await query.message.reply_text("⚠️ لم يتم العثور على المبلغ في النص!")
            return
        amount = float(amount_match.group(1).replace(",", ""))
        
        cfg = get_config()
        bonus_percent = float(cfg.get("Bouns_Gift", {}).get("HAWALA", 0))
        bonus_amount = 0
        if bonus_percent > 0:
            bonus_amount = round(amount * (bonus_percent / 100))
            
        # إضافة الرصيد
        account["balance"] += amount + bonus_amount
        account["total_deposited"] += amount

        # حفظ السجل
        log_entry = {
            "user_id": user_id_str,
            "type": "deposit",
            "method": "hawala",
            "amount": amount,
            "timestamp": time.time(),
        }
        db.setdefault("transaction_logs", []).append(log_entry)
        save_all_changes()

        # تعديل رسالة القناة
        new_caption = (
            f"✅ <b>تمت الموافقة على الحوالة</b>\n\n"
            f"👤 المستخدم: <code>{user_id_str}</code>\n"
            f"💰 المبلغ: {amount:,.0f} ل.س\n"
            f"🎁 البونص: {bonus_amount:,.0f} ل.س ({bonus_percent:.1f}%)\n"
            f"💳 الطريقة: حوالة (هرم/فؤاد)\n"
            f"🕒 {time.strftime('%Y-%m-%d %H:%M:%S')}"
        )
        try:
            await query.edit_message_caption(
                caption=new_caption,
                parse_mode="HTML",
                reply_markup=None
            )
        except Exception:
            await query.message.edit_text(new_caption, parse_mode="HTML")

        # إشعار المستخدم
        # إشعار المستخدم مع تفاصيل البونص
        try:
            total_amount = amount + bonus_amount
            await context.bot.send_message(
                chat_id=int(user_id),
                text=(
                    f"✅ تمت الموافقة على حوالتك!\n\n"
                    f"💰 المبلغ الأساسي: {amount:,.0f} ل.س\n"
                    f"🎁 بونص الإيداع: {bonus_amount:,.0f} ل.س ({bonus_percent:.1f}%)\n"
                    f"💳 المجموع المضاف إلى محفظتك: {total_amount:,.0f} ل.س 💰\n\n"
                    f"شكراً لاستخدامك خدمتنا ❤️"
                )
            )
        except Exception as e:
            print(f"⚠️ فشل إرسال إشعار للمستخدم {user_id}: {e}")


        # إشعار القناة بنتيجة العملية (اختياري)
        await context.bot.send_message(
            chat_id=OPERATIONS_CHANNEL_ID,
            text=f"📬 <b>إيداع (هرم/فؤاد)</b>\n👤 المستخدم: <code>{user_id}</code>\n💰 المبلغ: {amount:,.0f} ل.س\n✅ تمت الموافقة من الأدمن",
            parse_mode="HTML"
        )

        await query.answer("تمت الموافقة ✅", show_alert=True)

    except Exception as e:
        print(f"❌ خطأ أثناء معالجة الموافقة: {e}")
        await query.answer("⚠️ حدث خطأ أثناء الموافقة.", show_alert=True)
async def admin_reject_hawala_deposit(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    try:
        user_id = query.data.split(":")[1]
        user_id_str = str(user_id)

        # استخراج المبلغ من الرسالة
        text = query.message.caption or query.message.text or ""
        import re
        amount_match = re.search(r"💰 المبلغ:\s*([\d,\.]+)", text)
        amount = float(amount_match.group(1).replace(",", "")) if amount_match else 0

        # إعلام المستخدم
        await context.bot.send_message(
            chat_id=int(user_id),
            text=f"❌ تم رفض طلب الإيداع من قبل الإدارة."
        )

        # تعديل الرسالة في القناة
        new_caption = (
            f"❌ تم رفض إيداع حوالة هرم/فؤاد\n"
            f"👤 المستخدم: <code>{user_id_str}</code>\n"
            f"💰 المبلغ: {amount:,.0f} ل.س\n"
            f"🕒 {time.strftime('%Y-%m-%d %H:%M:%S')}"
        )
        if query.message.photo:
            await query.edit_message_caption(caption=new_caption, parse_mode="HTML", reply_markup=None)
        else:
            await query.edit_message_text(new_caption, parse_mode="HTML", reply_markup=None)

        await query.answer("تم الرفض ❌", show_alert=True)

    except Exception as e:
        print(f"❌ خطأ أثناء معالجة الرفض: {e}")
        await query.answer("⚠️ حدث خطأ أثناء الرفض.", show_alert=True)
