from telegram import InlineKeyboardButton, InlineKeyboardMarkup, Update
from telegram.ext import ContextTypes, ConversationHandler
from database import get_all_pending_deposits,add_used_transaction,get_pending_deposit_by_code, add_transaction , get_pending_deposit , delete_pending_deposit


async def pending_deposits(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    pending = get_all_pending_deposits()  # ← دالة يجب أن تكون موجودة في الـ database

    if not pending:
        await query.edit_message_text("❌ لا توجد طلبات إيداع معلقة حالياً.")
        return

    text = "🟡 <b>طلبات الإيداع المعلقة</b>:\n\n"

    keyboard = []

    for req in pending:
        req_id = req["request_id"]
        user_id = req["user_id"]
        amount = req["amount"]
        op_code = req["client_number"]

        text += (
            f"🔶 <b>طلب #{req_id}</b>\n"
            f"👤 المستخدم: <code>{user_id}</code>\n"
            f"💰 المبلغ: {amount:,} ل.س\n"
            f"📄 رقم العملية: <code>{op_code}</code>\n\n"
        )

        keyboard.append([
            InlineKeyboardButton("✅ موافقة", callback_data=f"approve_deposit:{req_id}"),
            InlineKeyboardButton("❌ رفض", callback_data=f"reject_deposit:{req_id}")
        ])

    await query.edit_message_text(
        text,
        reply_markup=InlineKeyboardMarkup(keyboard),
        parse_mode="HTML"
    )

from telegram import InlineKeyboardButton, InlineKeyboardMarkup, Update
from telegram.ext import ContextTypes

# استدعاء دوال قاعدة البيانات
from database import get_all_pending_deposits, get_pending_deposit_by_code, delete_pending_deposit, add_transaction


async def admin_deposits_buttons_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    data = query.data

    # ===========================
    # عرض جميع طلبات الإيداع المعلقة
    # ===========================
    if data == "pending_deposits":
        pending = get_all_pending_deposits()
        if not pending:
            await query.edit_message_text("❌ لا توجد طلبات إيداع معلقة حالياً.")
            return

        text = "🟡 <b>طلبات الإيداع المعلقة</b>:\n\n"
        keyboard = []

        for req in pending:
            op_code = req["operation_code"]
            user_id = req["user_id"]
            amount = req["amount"]

            text += (
                f"🔶 <b>طلب {op_code}</b>\n"
                f"👤 المستخدم: <code>{user_id}</code>\n"
                f"💰 المبلغ: {amount:,} ل.س\n"
                f"📄 رقم العملية: <code>{op_code}</code>\n\n"
            )

            keyboard.append([
                InlineKeyboardButton("✅ موافقة", callback_data=f"approve_deposit:{op_code}"),
                InlineKeyboardButton("❌ رفض", callback_data=f"reject_deposit:{op_code}")
            ])

        await query.edit_message_text(
            text,
            reply_markup=InlineKeyboardMarkup(keyboard),
            parse_mode="HTML"
        )
        return

    # ===========================
    # معالجة زر الموافقة أو الرفض
    # ===========================
    if data.startswith("approve_deposit:") or data.startswith("reject_deposit:"):
        action, op_code = data.split(":")
        req = get_pending_deposit_by_code(op_code)
        if not req:
            await query.edit_message_text("❌ الطلب غير موجود أو تمت معالجته بالفعل.")
            return

        user_id = req["user_id"]
        amount = req["amount"]

        if action == "approve_deposit":
            # إضافة الرصيد وسجل المعاملة
            add_transaction(
                user_id=user_id,
                tx_type="deposit",
                method="syriatel",
                amount=amount,
                status="approved",
                client_number=req["operation_code"]
            )

            # حذف الطلب المعلق
            delete_pending_deposit(req["operation_code"])

            # إعلام المستخدم
            try:
                await context.bot.send_message(
                    chat_id=user_id,
                    text=f"✅ تم قبول طلب الإيداع.\n📄 رقم العملية: {req['operation_code']}\n💰 المبلغ المضاف: {amount:,} ل.س",
                    parse_mode="HTML"
                )
            except:
                pass

            await query.edit_message_text("✅ تم قبول طلب الإيداع وإضافة الرصيد بنجاح.")

        elif action == "reject_deposit":
            # حذف الطلب فقط
            delete_pending_deposit(req["operation_code"])

            # إعلام المستخدم
            try:
                await context.bot.send_message(
                    chat_id=user_id,
                    text=f"❌ تم رفض طلب الإيداع.\n📄 رقم العملية: {req['operation_code']}",
                    parse_mode="HTML"
                )
            except:
                pass

            await query.edit_message_text("❌ تم رفض طلب الإيداع.")

async def approve_deposit(update: Update, context: ContextTypes.DEFAULT_TYPE, op_code):
    req = get_pending_deposit_by_code(op_code)
    if not req:
        await update.callback_query.edit_message_text("❌ الطلب غير موجود أو تمت معالجته بالفعل.")
        return

    user_id = req["user_id"]
    amount = req["amount"]

    # 1) إضافة الرصيد وسجل المعاملة
    add_transaction(
        user_id=user_id,
        tx_type="deposit",
        method="syriatel",
        amount=amount,
        status="approved",
        client_number=req["client_number"]
    )
    await add_used_transaction(
        reference_id=req["operation_code"],
        amount=amount,
        method="syriatel",
        user_id=user_id
    )

    # 2) حذف الطلب المعلق
    delete_pending_deposit(req["client_number"])

    # 3) إعلام المستخدم
    try:
        await context.bot.send_message(
            chat_id=user_id,
            text=f"✅ تم قبول طلب الإيداع.\n📄 رقم العملية: {req['client_number']}\n💰 المبلغ المضاف: {amount:,} ل.س",
            parse_mode="HTML"
        )
    except:
        pass

    await update.callback_query.edit_message_text("✅ تم قبول طلب الإيداع وإضافة الرصيد بنجاح.")


async def reject_deposit(update: Update, context: ContextTypes.DEFAULT_TYPE, op_code):
    req = get_pending_deposit_by_code(op_code)
    if not req:
        await update.callback_query.edit_message_text("❌ الطلب غير موجود أو تمت معالجته.")
        return

    user_id = req["user_id"]

    # حذف الطلب فقط
    delete_pending_deposit(req["client_number"])

    # إعلام المستخدم
    try:
        await context.bot.send_message(
            chat_id=user_id,
            text=f"❌ تم رفض طلب الإيداع.\n📄 رقم العملية: {req['client_number']}",
            parse_mode="HTML"
        )
    except:
        pass

    await update.callback_query.edit_message_text("❌ تم رفض طلب الإيداع.")
