from telegram import InlineKeyboardButton, InlineKeyboardMarkup, Update
from telegram.ext import CallbackContext, ConversationHandler
from config import ADMIN_IDS

# ✅ استيراد دوال SQLite الجديدة
from database import add_admin_history
from handlers.admin.chamcash_withdraw import execute_chamcash_withdrawal
from handlers.admin.admin_menu import admin_panel_handler

ADMIN_WITHDRAW_CURRENCY, ADMIN_WITHDRAW_AMOUNT, ADMIN_WITHDRAW_CODE = range(3)


async def admin_withdraw_chamcash_start(update: Update, context: CallbackContext):
    query = update.callback_query
    await query.answer()

    user_id_str = str(query.from_user.id)
    
    # ✅ التحقق من صلاحيات الأدمن باستخدام ID كنص
    if user_id_str not in [str(admin_id) for admin_id in ADMIN_IDS]:
        await query.edit_message_text("🚫 هذا الخيار متاح فقط للأدمن.")
        return ConversationHandler.END

    keyboard = [
        [InlineKeyboardButton("💵 دولار USD", callback_data="admin_usd")],
        [InlineKeyboardButton("💴 ليرة سورية SYP", callback_data="admin_syr")],
        [InlineKeyboardButton("❌ إلغاء العملية", callback_data="cancel_withdraw")]
    ]

    await query.edit_message_text(
        "💰 اختر العملة التي تريد سحبها:",
        reply_markup=InlineKeyboardMarkup(keyboard)
    )
    return ADMIN_WITHDRAW_CURRENCY


async def admin_withdraw_chamcash_currency(update: Update, context: CallbackContext):
    query = update.callback_query
    await query.answer()

    if query.data == "cancel_withdraw":
        await query.edit_message_text("❌ تم إلغاء العملية.")
        await admin_panel_handler(update, context)
        return ConversationHandler.END

    context.user_data["withdraw_currency"] = "USD" if query.data == "admin_usd" else "SYP"
    await query.edit_message_text("💰 أدخل المبلغ الذي تريد تحويله:")
    return ADMIN_WITHDRAW_AMOUNT


async def admin_withdraw_chamcash_amount(update: Update, context: CallbackContext):
    try:
        amount = float(update.message.text)
        if amount <= 0:
            raise ValueError

        context.user_data["withdraw_amount"] = amount
        await update.message.reply_text("📞 الآن أرسل كود العميل الذي تريد التحويل إليه:")
        return ADMIN_WITHDRAW_CODE

    except:
        await update.message.reply_text("❌ أدخل مبلغًا صحيحًا.")
        return ADMIN_WITHDRAW_AMOUNT


async def admin_withdraw_chamcash_code(update: Update, context: CallbackContext):
    client_code = update.message.text.strip()
    amount = context.user_data["withdraw_amount"]
    currency = context.user_data["withdraw_currency"]
    user_id_str = str(update.effective_user.id)

    await update.message.reply_text(
        f"⏳ جاري تنفيذ السحب {int(amount):,} {currency} إلى {client_code}..."
    )

    # ✅ تنفيذ عملية السحب
    success = execute_chamcash_withdrawal(client_code, amount, currency)
    status = "success" if success else "failed"

    # ✅ إضافة سجل للأدمن في SQLite - تصحيح اسم المعامل
    add_admin_history(
        user_identifier=user_id_str,  # ✅ استخدام user_identifier بدلاً من admin_id
        operation_type="admin_withdraw_chamcash",
        amount=amount,
        method=f"chamcash_{currency.lower()}",
        status=status,
        extra={
            "client_code": client_code,
            "currency": currency,
            "amount_requested": amount
        }
    )

    # ✅ إضافة سجل لجميع الأدمن الآخرين للإشعار
    for admin_id in ADMIN_IDS:
        if str(admin_id) != user_id_str:  # لا نكرر تسجيل الأدمن الذي نفذ العملية
            add_admin_history(
                user_identifier=str(admin_id),
                operation_type="admin_action_notification",
                amount=amount,
                method="notification",
                status=status,
                extra={
                    "performed_by": user_id_str,
                    "action": "withdraw_chamcash",
                    "client_code": client_code,
                    "currency": currency
                }
            )

    # تنظيف البيانات
    context.user_data.clear()

    if success:
        await update.message.reply_text(
            f"✅ تم السحب بنجاح {int(amount):,} {currency} إلى {client_code}"
        )
    else:
        await update.message.reply_text("❌ فشل تنفيذ عملية السحب.")

    return ConversationHandler.END