# handlers/admin/broadcast.py

from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes, ConversationHandler
from constants import AWAITING_BROADCAST_MESSAGE
from database import get_all_user_ids


async def start_broadcast_message(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    cancel_button = [
        [InlineKeyboardButton("❌ إلغاء الإرسال", callback_data="cancel_broadcast")]
    ]
    markup = InlineKeyboardMarkup(cancel_button)

    await query.edit_message_text(
        "📢 الرجاء كتابة الرسالة التي تريد إرسالها لجميع المستخدمين:",
        reply_markup=markup
    )
    return AWAITING_BROADCAST_MESSAGE


async def receive_broadcast_message(update: Update, context: ContextTypes.DEFAULT_TYPE):
    # تحقق من الإلغاء (اختياري)
    if context.user_data.get('broadcast_cancelled'):
        await update.message.reply_text("❌ تم إلغاء هذه العملية مسبقًا.")
        context.user_data.pop('broadcast_cancelled', None)
        return ConversationHandler.END

    message_text = update.message.text.strip()
    if not message_text:
        await update.message.reply_text("❌ الرسالة فارغة. أعد المحاولة:")
        return AWAITING_BROADCAST_MESSAGE

    # جلب جميع المعرفات
    user_ids = get_all_user_ids()

    if not user_ids:
        await update.message.reply_text("📭 لا يوجد مستخدمون في قاعدة البيانات.")
        return ConversationHandler.END

    sent_count = 0
    failed_count = 0

    for user_id in user_ids:
        try:
            await context.bot.send_message(
                chat_id=user_id,
                text=message_text,
                parse_mode=None  # لا تستخدم Markdown/HTML إلا إذا طلب الأدمن
            )
            sent_count += 1
        except Exception as e:
            # يمكنك تسجيل الخطأ في ملف أو تجاهله
            print(f"[Broadcast] فشل إرسال رسالة للمستخدم {user_id}: {e}")
            failed_count += 1

    await update.message.reply_text(
        f"✅ تم إرسال الرسالة بنجاح إلى {sent_count} مستخدم.\n"
        f"❌ فشل الإرسال إلى {failed_count} مستخدم."
    )
    return ConversationHandler.END


async def cancel_broadcast_message(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    context.user_data['broadcast_cancelled'] = True
    await query.edit_message_text("❌ تم إلغاء إرسال الرسالة الجماعية.")
    return ConversationHandler.END