# global_state.py
import asyncio

GLOBAL_LOCK_ACTIVE = False
LOCK_EXPIRY_TASK = None

async def activate_global_lock(duration=3):
    global GLOBAL_LOCK_ACTIVE, LOCK_EXPIRY_TASK

    # إلغاء المهمة السابقة إن وُجدت
    if LOCK_EXPIRY_TASK and not LOCK_EXPIRY_TASK.done():
        LOCK_EXPIRY_TASK.cancel()

    GLOBAL_LOCK_ACTIVE = True

    async def deactivate():
        await asyncio.sleep(duration)
        global GLOBAL_LOCK_ACTIVE
        GLOBAL_LOCK_ACTIVE = False

    LOCK_EXPIRY_TASK = asyncio.create_task(deactivate())


def is_global_lock_active():
    return GLOBAL_LOCK_ACTIVE