import time
from database import get_connection
import sqlite3
import datetime


def get_wheel_players_last_24h():
    try:
        with get_connection() as conn:
            cur = conn.cursor()
            
            # الوقت الحالي بالثواني
            now = int(time.time())
            # أسبوع مضى (7 أيام * 24 ساعة * 3600 ثانية)
            one_week_ago = now - (7 * 24 * 3600)
            
            query = """
                SELECT user_id, username, last_wheel_spin 
                FROM user_accounts 
                WHERE last_wheel_spin >= ?
                ORDER BY last_wheel_spin DESC
            """
            cur.execute(query, (one_week_ago,))
            players = cur.fetchall()
            
            print(f"--- تقرير العجلة (آخر 7 أيام) ---")
            if not players:
                print("لم يلعب أحد خلال هذا الأسبوع.")
                return

            for p in players:
                uid, name, ts = p
                # تحويل الوقت لشكل مفهوم (السنة-الشهر-اليوم الساعة:الدقيقة)
                date_str = datetime.fromtimestamp(ts).strftime('%Y-%m-%d %H:%M')
                print(f"👤 {name} ({uid}) | 📅 {date_str}")
                
            print(f"-------------------------------")
            print(f"إجمالي عدد اللاعبين: {len(players)}")

    except Exception as e:
        print(f"❌ حدث خطأ أثناء جلب البيانات: {e}")

# استدعاء الدالة

if __name__ == "__main__":
    
    get_wheel_players_last_24h()